/*
 * Decompiled with CFR 0.152.
 */
package lux.index.field;

import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import lux.index.FieldRole;
import lux.index.IndexConfiguration;
import lux.index.XmlIndexer;
import lux.index.analysis.DefaultAnalyzer;
import lux.index.analysis.ElementTokenStream;
import lux.index.analysis.QNameTokenFilter;
import lux.index.field.FieldDefinition;
import lux.index.field.FieldValues;
import lux.xml.SaxonDocBuilder;
import net.sf.saxon.s9api.XdmNode;
import org.apache.commons.io.input.CharSequenceReader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;

public class ElementTextField
extends FieldDefinition {
    public ElementTextField() {
        super(FieldRole.ELEMENT_TEXT, new DefaultAnalyzer(), Field.Store.NO, FieldDefinition.Type.TOKENS);
    }

    public Iterable<IndexableField> getFieldValues(XmlIndexer indexer) {
        XdmNode doc = indexer.getXdmNode();
        if (doc != null && doc.getUnderlyingNode() != null) {
            SaxonDocBuilder builder = indexer.getSaxonDocBuilder();
            Analyzer analyzer = this.getAnalyzer();
            TokenStream textTokens = null;
            try {
                textTokens = analyzer.tokenStream(this.getName(), (Reader)new CharSequenceReader((CharSequence)""));
            }
            catch (IOException e) {
                // empty catch block
            }
            ElementTokenStream tokens = new ElementTokenStream(this.getName(), analyzer, textTokens, doc, builder.getOffsets());
            IndexConfiguration config = indexer.getConfiguration();
            ((QNameTokenFilter)tokens.getWrappedTokenStream()).setNamespaceAware(config.isOption(4));
            config.configureElementVisibility(tokens);
            return new FieldValues(this, Collections.singleton(new TextField(this.getName(), (TokenStream)tokens)));
        }
        return Collections.emptySet();
    }
}

