/*
 * Decompiled with CFR 0.152.
 */
package lux.index.field;

import java.nio.charset.Charset;
import java.util.Collections;
import lux.index.FieldRole;
import lux.index.XmlIndexer;
import lux.index.field.FieldDefinition;
import lux.xml.tinybin.TinyBinary;
import net.sf.saxon.tree.tiny.TinyDocumentImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;

public class TinyBinaryField
extends FieldDefinition {
    public static final Charset UTF8 = Charset.forName("utf-8");

    public TinyBinaryField() {
        super(FieldRole.XML_STORE, null, Field.Store.YES, FieldDefinition.Type.BYTES, true);
    }

    protected TinyBinary makeTinyBinary(XmlIndexer indexer) {
        TinyTree tinyTree = ((TinyDocumentImpl)indexer.getXdmNode().getUnderlyingNode()).getTree();
        return new TinyBinary(tinyTree, UTF8);
    }

    @Override
    public Iterable<?> getValues(XmlIndexer indexer) {
        TinyBinary tinyBinary = this.makeTinyBinary(indexer);
        return Collections.singleton(new StoredField(this.getName(), tinyBinary.getBytes(), 0, tinyBinary.length()));
    }
}

