/*
 * Decompiled with CFR 0.152.
 */
package lux.index.field;

import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import lux.index.FieldRole;
import lux.index.XmlIndexer;
import lux.index.analysis.DefaultAnalyzer;
import lux.index.analysis.XmlTextTokenStream;
import lux.index.field.FieldDefinition;
import lux.index.field.FieldValues;
import lux.xml.SaxonDocBuilder;
import net.sf.saxon.s9api.XdmNode;
import org.apache.commons.io.input.CharSequenceReader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;

public class XmlTextField
extends FieldDefinition {
    public XmlTextField() {
        super(FieldRole.XML_TEXT, new DefaultAnalyzer(), Field.Store.NO, FieldDefinition.Type.TOKENS, true);
    }

    public XmlTextField(String name, Analyzer analyzer) {
        super(analyzer, Field.Store.NO, FieldDefinition.Type.TOKENS);
        this.setName(name);
    }

    public Iterable<IndexableField> getFieldValues(XmlIndexer indexer) {
        XdmNode doc = indexer.getXdmNode();
        if (doc != null && doc.getUnderlyingNode() != null) {
            SaxonDocBuilder builder = indexer.getSaxonDocBuilder();
            String fieldName = this.getName();
            Analyzer analyzer = this.getAnalyzer();
            TokenStream textTokens = null;
            try {
                textTokens = analyzer.tokenStream(fieldName, (Reader)new CharSequenceReader((CharSequence)""));
            }
            catch (IOException e) {
                // empty catch block
            }
            XmlTextTokenStream tokens = new XmlTextTokenStream(fieldName, analyzer, textTokens, doc, builder.getOffsets());
            indexer.getConfiguration().configureElementVisibility(tokens);
            return new FieldValues(this, Collections.singleton(new TextField(fieldName, (TokenStream)tokens)));
        }
        return Collections.emptySet();
    }
}

