/*
 * Decompiled with CFR 0.152.
 */
package lux.query;

import lux.index.IndexConfiguration;
import lux.query.ParseableQuery;
import lux.query.parser.LuxQueryParser;
import lux.xml.QName;
import lux.xpath.LiteralExpression;
import lux.xquery.AttributeConstructor;
import lux.xquery.ElementConstructor;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.index.Term;

public class NodeTextQuery
extends ParseableQuery {
    private static final LiteralExpression BOOST_ATTR_NAME = new LiteralExpression("boost");
    private static final LiteralExpression FIELD_ATTR_NAME = new LiteralExpression("fieldName");
    private static final LiteralExpression QNAME_ATTR_NAME = new LiteralExpression("qName");
    private static final QName QUERY_QNAME = new QName("QNameTextQuery");
    private final Term term;
    private final float boost;
    private final String qName;

    public NodeTextQuery(Term t, String qName, float boost) {
        this.term = t;
        this.boost = boost;
        this.qName = qName;
    }

    public NodeTextQuery(Term t, String qName) {
        this(t, qName, 1.0f);
    }

    public NodeTextQuery(Term t) {
        this(t, null, 1.0f);
    }

    @Override
    public ElementConstructor toXmlNode(String field, IndexConfiguration config) {
        return this.toXmlNode(field, QUERY_QNAME);
    }

    protected ElementConstructor toXmlNode(String field, QName elementName) {
        AttributeConstructor fieldAtt = null;
        if (!this.term.field().isEmpty()) {
            field = this.term.field();
        }
        fieldAtt = new AttributeConstructor(FIELD_ATTR_NAME, new LiteralExpression(this.term.field()));
        AttributeConstructor boostAtt = null;
        if (this.boost != 1.0f) {
            boostAtt = new AttributeConstructor(BOOST_ATTR_NAME, new LiteralExpression(Float.valueOf(this.boost)));
        }
        AttributeConstructor qNameAtt = null;
        if (this.qName != null) {
            qNameAtt = new AttributeConstructor(QNAME_ATTR_NAME, new LiteralExpression(this.qName));
        }
        return new ElementConstructor(elementName, new LiteralExpression(this.term.text()), fieldAtt, qNameAtt, boostAtt);
    }

    @Override
    public String toQueryString(String field, IndexConfiguration config) {
        StringBuilder buf = new StringBuilder();
        String tf = this.term.field();
        String text = LuxQueryParser.escapeQParser(this.term.text());
        if (StringUtils.isBlank((String)this.qName)) {
            buf.append('<').append(':').append(text);
        } else if (tf.equals(config.getElementTextFieldName())) {
            buf.append('<').append(this.qName).append(':').append(text);
        } else if (tf.equals(config.getAttributeTextFieldName())) {
            buf.append("<@").append(this.qName).append(':').append(text);
        } else {
            throw new IllegalStateException("QNameTextQuery has qName with non-node field: " + tf);
        }
        if (this.boost != 1.0f) {
            buf.append('^').append(this.boost);
        }
        return buf.toString();
    }

    @Override
    public boolean equals(ParseableQuery other) {
        if (other instanceof NodeTextQuery) {
            NodeTextQuery oq = (NodeTextQuery)other;
            return oq.boost == this.boost && oq.qName.equals(this.qName) && oq.term.equals((Object)this.term);
        }
        return false;
    }
}

