/*
 * Decompiled with CFR 0.152.
 */
package lux.query;

import java.util.ArrayList;
import lux.index.IndexConfiguration;
import lux.query.ParseableQuery;
import lux.query.parser.LuxQueryParser;
import lux.xml.QName;
import lux.xpath.LiteralExpression;
import lux.xquery.AttributeConstructor;
import lux.xquery.ElementConstructor;

public class RangePQuery
extends ParseableQuery {
    public static final LiteralExpression FIELD_ATTR_NAME = new LiteralExpression("fieldName");
    private static final LiteralExpression TYPE_ATTR_NAME = new LiteralExpression("type");
    private static final LiteralExpression LOWER_TERM_ATTR_NAME = new LiteralExpression("lowerTerm");
    private static final LiteralExpression UPPER_TERM_ATTR_NAME = new LiteralExpression("upperTerm");
    private static final LiteralExpression INCLUDE_LOWER_ATTR_NAME = new LiteralExpression("includeLower");
    private static final LiteralExpression INCLUDE_UPPER_ATTR_NAME = new LiteralExpression("includeUpper");
    public static final QName TERM_RANGE_QUERY_QNAME = new QName("TermRangeQuery");
    public static final QName NUMERIC_RANGE_QUERY_QNAME = new QName("NumericRangeQuery");
    private String fieldName;
    private String lowerTerm;
    private String upperTerm;
    private boolean includeLower;
    private boolean includeUpper;
    private Type type;

    public RangePQuery(String fieldName, Type type, String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper) {
        this.fieldName = fieldName;
        this.lowerTerm = lowerTerm;
        this.upperTerm = upperTerm;
        this.includeLower = includeLower;
        this.includeUpper = includeUpper;
        this.type = type;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getLowerTerm() {
        return this.lowerTerm;
    }

    public String getUpperTerm() {
        return this.upperTerm;
    }

    public boolean getIncludeLower() {
        return this.includeLower;
    }

    public boolean getincludeUpper() {
        return this.includeUpper;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public ElementConstructor toXmlNode(String field, IndexConfiguration config) {
        ArrayList<AttributeConstructor> atts = new ArrayList<AttributeConstructor>();
        atts.add(new AttributeConstructor(FIELD_ATTR_NAME, new LiteralExpression(this.fieldName)));
        if (this.lowerTerm != null) {
            atts.add(new AttributeConstructor(LOWER_TERM_ATTR_NAME, new LiteralExpression(this.lowerTerm)));
        }
        if (this.upperTerm != null) {
            atts.add(new AttributeConstructor(UPPER_TERM_ATTR_NAME, new LiteralExpression(this.upperTerm)));
        }
        atts.add(new AttributeConstructor(INCLUDE_LOWER_ATTR_NAME, new LiteralExpression(Boolean.toString(this.includeLower))));
        atts.add(new AttributeConstructor(INCLUDE_UPPER_ATTR_NAME, new LiteralExpression(Boolean.toString(this.includeUpper))));
        if (!this.type.isNumeric) {
            return new ElementConstructor(TERM_RANGE_QUERY_QNAME, LiteralExpression.EMPTY, atts.toArray(new AttributeConstructor[atts.size()]));
        }
        atts.add(new AttributeConstructor(TYPE_ATTR_NAME, new LiteralExpression(this.type.toString())));
        return new ElementConstructor(NUMERIC_RANGE_QUERY_QNAME, LiteralExpression.EMPTY, atts.toArray(new AttributeConstructor[atts.size()]));
    }

    @Override
    public String toQueryString(String field, IndexConfiguration config) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.fieldName).append(':').append(this.includeLower ? (char)'[' : '{').append(this.lowerTerm == null ? Character.valueOf('*') : LuxQueryParser.escapeQParser(this.lowerTerm)).append(" TO ").append(this.upperTerm == null ? Character.valueOf('*') : LuxQueryParser.escapeQParser(this.upperTerm)).append(this.includeUpper ? (char)']' : '}');
        return buf.toString();
    }

    public boolean intersect(RangePQuery other) {
        int cmp;
        if (!other.fieldName.equals(this.fieldName) || !other.type.equals((Object)this.type)) {
            return false;
        }
        if (other.lowerTerm != null) {
            if (this.lowerTerm == null) {
                this.lowerTerm = other.lowerTerm;
                this.includeLower = other.includeLower;
            } else {
                cmp = this.compare(this.lowerTerm, other.lowerTerm);
                if (cmp == 0) {
                    this.includeLower = this.includeLower && other.includeLower;
                } else if (cmp < 0) {
                    this.lowerTerm = other.lowerTerm;
                    this.includeLower = other.includeLower;
                }
            }
        }
        if (other.upperTerm != null) {
            if (this.upperTerm == null) {
                this.upperTerm = other.upperTerm;
                this.includeUpper = other.includeUpper;
            } else {
                cmp = this.compare(this.upperTerm, other.upperTerm);
                if (cmp == 0) {
                    this.includeUpper = this.includeUpper && other.includeUpper;
                } else if (cmp > 0) {
                    this.upperTerm = other.upperTerm;
                    this.includeUpper = other.includeUpper;
                }
            }
        }
        return true;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof RangePQuery)) {
            return false;
        }
        RangePQuery oq = (RangePQuery)other;
        if (this.includeLower != oq.includeLower || this.includeUpper != oq.includeUpper) {
            return false;
        }
        if (this.lowerTerm == null != (oq.lowerTerm == null) || this.upperTerm == null != (oq.upperTerm == null)) {
            return false;
        }
        return !(this.lowerTerm != null && !this.lowerTerm.equals(oq.lowerTerm) || this.upperTerm != null && !this.upperTerm.equals(oq.upperTerm));
    }

    private int compare(String t1, String t2) {
        if (this.type.isNumeric) {
            return Double.valueOf(t1).compareTo(Double.valueOf(t2));
        }
        return t1.compareTo(t2);
    }

    @Override
    public boolean equals(ParseableQuery other) {
        return this.equals((Object)other);
    }

    public static enum Type {
        STRING(false),
        INT,
        LONG,
        FLOAT,
        DOUBLE;

        public boolean isNumeric;

        private Type(boolean numeric) {
            this.isNumeric = numeric;
        }

        private Type() {
            this.isNumeric = true;
        }
    }
}

