/*
 * Decompiled with CFR 0.152.
 */
package lux.query;

import lux.index.IndexConfiguration;
import lux.query.ParseableQuery;
import lux.query.parser.LuxQueryParser;
import lux.xml.QName;
import lux.xpath.LiteralExpression;
import lux.xquery.AttributeConstructor;
import lux.xquery.ElementConstructor;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.index.Term;

public class TermPQuery
extends ParseableQuery {
    private static final LiteralExpression BOOST_ATTR_NAME = new LiteralExpression("boost");
    public static final LiteralExpression FIELD_ATTR_NAME = new LiteralExpression("fieldName");
    public static final QName TERM_QUERY_QNAME = new QName("TermQuery");
    private final Term term;
    private final float boost;

    public TermPQuery(Term t, float boost) {
        this.term = t;
        this.boost = boost;
    }

    public TermPQuery(Term t) {
        this(t, 1.0f);
    }

    public Term getTerm() {
        return this.term;
    }

    public float getBoost() {
        return this.boost;
    }

    @Override
    public ElementConstructor toXmlNode(String field, IndexConfiguration config) {
        return this.toXmlNode(field, TERM_QUERY_QNAME);
    }

    protected ElementConstructor toXmlNode(String field, QName elementName) {
        AttributeConstructor fieldAtt = new AttributeConstructor(FIELD_ATTR_NAME, new LiteralExpression(this.term.field()));
        AttributeConstructor boostAtt = null;
        if (this.boost != 1.0f) {
            boostAtt = new AttributeConstructor(BOOST_ATTR_NAME, new LiteralExpression(Float.valueOf(this.boost)));
        }
        return new ElementConstructor(elementName, new LiteralExpression(this.term.text()), fieldAtt, boostAtt);
    }

    @Override
    public String toQueryString(String field, IndexConfiguration config) {
        StringBuilder buf = new StringBuilder();
        if (StringUtils.isBlank((String)this.term.field())) {
            buf.append(field);
        } else {
            buf.append(this.term.field());
        }
        buf.append(':');
        buf.append(LuxQueryParser.escapeQParser(this.term.text()));
        if (this.boost != 1.0f) {
            buf.append('^').append(Float.toString(this.boost));
        }
        return buf.toString();
    }

    @Override
    public boolean equals(ParseableQuery other) {
        if (other instanceof TermPQuery) {
            return this.term.equals((Object)((TermPQuery)other).term) && this.boost == ((TermPQuery)other).boost;
        }
        return false;
    }
}

