/*
 * Decompiled with CFR 0.152.
 */
package lux.solr;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.servlet.SolrDispatchFilter;

public class LuxDispatchFilter
extends SolrDispatchFilter {
    private String baseURI;
    private String[] baseURIArr;

    public void init(FilterConfig filterConfig) throws ServletException {
        URI uri;
        super.init(filterConfig);
        this.baseURI = filterConfig.getInitParameter("base-uri");
        if (this.baseURI == null) {
            String path = filterConfig.getServletContext().getRealPath("/");
            path = path == null ? "resource:/" : (File.separatorChar == '\\' ? "///" + path.replace('\\', '/') : "//" + path);
            try {
                uri = new URI("file", path, null);
            }
            catch (URISyntaxException e) {
                throw new ServletException("Malformed URI for path: " + path, (Throwable)e);
            }
        }
        try {
            uri = new URI(this.baseURI);
        }
        catch (URISyntaxException e) {
            throw new ServletException("Malformed URI for path: " + this.baseURI, (Throwable)e);
        }
        this.baseURI = uri.toString();
        this.baseURIArr = new String[]{this.baseURI};
        String expathRepo = filterConfig.getInitParameter("org.expath.pkg.saxon.repo");
        if (expathRepo != null) {
            System.setProperty("org.expath.pkg.saxon.repo", expathRepo);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)request;
            Request wrapper = new Request(req);
            String path = req.getServletPath();
            String[] pc = path.split("/", 4);
            if (path.contains(".xq") && pc.length > 2) {
                int pathInfoOffset;
                String xquery;
                String handlerName;
                String coreName;
                if (pc.length > 3) {
                    coreName = pc[1];
                    handlerName = pc[2];
                    xquery = pc[3];
                } else {
                    coreName = "collection1";
                    handlerName = pc[1];
                    xquery = pc[2];
                }
                wrapper.setServletPath('/' + coreName + '/' + handlerName);
                String qs = req.getQueryString();
                HashMap<String, String[]> params = null;
                if (req.getMethod().equals("GET")) {
                    Map requestParams = req.getParameterMap();
                    params = new HashMap<String, String[]>(requestParams);
                }
                if ((pathInfoOffset = xquery.indexOf(".xqy/")) >= 0) {
                    String pathInfo = xquery.substring(pathInfoOffset += ".xqy/".length());
                    xquery = xquery.substring(0, pathInfoOffset - 1);
                    if (params != null) {
                        params.put("lux.pathInfo", new String[]{pathInfo});
                    }
                    qs = this.appendToQueryString(qs, "lux.pathInfo", pathInfo);
                }
                if (params != null) {
                    params.put("lux.xquery", new String[]{xquery});
                    params.put("lux.serverBaseUri", this.baseURIArr);
                }
                qs = this.appendToQueryString(qs, "lux.xquery", xquery);
                qs = this.appendToQueryString(qs, "lux.serverBaseUri", this.baseURI);
                wrapper.setQueryString(qs);
                wrapper.setParameterMap(params);
            }
            wrapper.setAttribute("lux.httpServletResponse", response);
            super.doFilter((ServletRequest)wrapper, response, chain);
            return;
        }
        super.doFilter(request, response, chain);
    }

    protected void execute(HttpServletRequest req, SolrRequestHandler handler, SolrQueryRequest sreq, SolrQueryResponse rsp) {
        sreq.getContext().put("lux.httpServletRequest", req);
        super.execute(req, handler, sreq, rsp);
    }

    private String appendToQueryString(String qs, String param, String value) throws UnsupportedEncodingException {
        if (qs == null) {
            return param + '=' + URLEncoder.encode(value, "UTF-8");
        }
        return qs + '&' + param + '=' + URLEncoder.encode(value, "utf-8");
    }

    public class Request
    extends HttpServletRequestWrapper {
        private Map<String, String[]> parameterMap;
        private String pathInfo;
        private String servletPath;
        private String queryString;

        public Request(HttpServletRequest req) {
            super(req);
        }

        public String getServletPath() {
            return this.servletPath == null ? super.getServletPath() : this.servletPath;
        }

        public String getPathInfo() {
            return this.pathInfo == null ? super.getPathInfo() : this.pathInfo;
        }

        public Map<String, String[]> getParameterMap() {
            return this.parameterMap == null ? super.getParameterMap() : this.parameterMap;
        }

        public String getQueryString() {
            return this.queryString == null ? super.getQueryString() : this.queryString;
        }

        public void setParameterMap(Map<String, String[]> map) {
            this.parameterMap = map;
        }

        public void setServletPath(String path) {
            this.servletPath = path;
        }

        public void setPathInfo(String path) {
            this.pathInfo = path;
        }

        public void setQueryString(String queryString) {
            this.queryString = queryString;
        }
    }
}

