/*
 * Decompiled with CFR 0.152.
 */
package lux.solr;

import java.io.IOException;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import lux.DocWriter;
import lux.Evaluator;
import lux.exception.LuxException;
import lux.index.FieldRole;
import lux.index.IndexConfiguration;
import lux.index.XmlIndexer;
import lux.solr.SolrQueryContext;
import lux.solr.UpdateDocCommand;
import lux.solr.XQueryComponent;
import lux.xml.tinybin.TinyBinary;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryRequestBase;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.UpdateHandler;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;
import org.slf4j.LoggerFactory;

public class SolrDocWriter
implements DocWriter {
    private final SolrCore core;
    private final XQueryComponent xqueryComponent;
    private final String uriFieldName;
    private final String xmlFieldName;

    SolrDocWriter(XQueryComponent xQueryComponent, SolrCore core) {
        this.core = core;
        this.xqueryComponent = xQueryComponent;
        IndexConfiguration indexConfig = xQueryComponent.getSolrIndexConfig().getIndexConfig();
        this.uriFieldName = indexConfig.getFieldName(FieldRole.URI);
        this.xmlFieldName = indexConfig.getFieldName(FieldRole.XML_STORE);
    }

    @Override
    public void write(NodeInfo node, String uri) {
        UpdateHandler updateHandler = this.core.getUpdateHandler();
        SolrInputDocument solrDoc = new SolrInputDocument();
        solrDoc.addField(this.uriFieldName, (Object)uri);
        if (this.isCloud()) {
            Serializer serializer = this.xqueryComponent.solrIndexConfig.checkoutSerializer();
            try {
                String xmlString = serializer.serializeNodeToString(new XdmNode(node));
                solrDoc.addField(this.xmlFieldName, (Object)xmlString);
            }
            catch (SaxonApiException e) {
                throw new LuxException(e);
            }
            finally {
                this.xqueryComponent.solrIndexConfig.returnSerializer(serializer);
            }
        } else if (updateHandler.getUpdateLog() != null) {
            if (node instanceof TinyNodeImpl) {
                TinyBinary tinybin = new TinyBinary(((TinyNodeImpl)node).getTree());
                solrDoc.addField(this.xmlFieldName, (Object)tinybin.getByteBuffer());
            } else {
                String xml = node.toString();
                solrDoc.addField(this.xmlFieldName, (Object)xml);
            }
        }
        if (this.isCloud()) {
            this.writeToCloud(solrDoc, uri);
        } else {
            this.writeLocal(solrDoc, node, uri);
        }
    }

    private void writeToCloud(SolrInputDocument solrDoc, String uri) {
        ArrayList<String> urls = this.xqueryComponent.getShardURLs(true);
        LoggerFactory.getLogger(this.getClass()).debug("writing " + uri + " to cloud at " + urls);
        SolrQueryResponse rsp = new SolrQueryResponse();
        SolrQueryRequest req = UpdateDocCommand.makeSolrRequest(this.core);
        ((ModifiableSolrParams)req.getParams()).add("shards", urls.toArray(new String[urls.size()]));
        UpdateRequest updateReq = new UpdateRequest();
        updateReq.add(solrDoc);
        UpdateDocCommand cmd = new UpdateDocCommand(req, solrDoc, null, uri);
        UpdateRequestProcessorChain updateChain = this.xqueryComponent.getCore().getUpdateProcessingChain("lux-update-chain");
        try {
            UpdateRequestProcessor processor = updateChain.createProcessor(req, rsp);
            processor.processAdd((AddUpdateCommand)cmd);
            processor.finish();
        }
        catch (IOException e) {
            throw new LuxException(e);
        }
    }

    private void writeLocal(SolrInputDocument solrDoc, NodeInfo node, String uri) {
        XmlIndexer indexer = null;
        try {
            indexer = this.xqueryComponent.getSolrIndexConfig().checkoutXmlIndexer();
            try {
                indexer.index(node, uri);
            }
            catch (XMLStreamException e) {
                throw new LuxException(e);
            }
            UpdateDocCommand cmd = new UpdateDocCommand(this.core, indexer.createLuceneDocument(), uri);
            cmd.solrDoc = solrDoc;
            this.core.getUpdateHandler().addDoc((AddUpdateCommand)cmd);
        }
        catch (IOException e) {
            throw new LuxException(e);
        }
        finally {
            if (indexer != null) {
                this.xqueryComponent.getSolrIndexConfig().returnXmlIndexer(indexer);
            }
        }
    }

    @Override
    public void delete(String uri) {
        DeleteUpdateCommand cmd = new DeleteUpdateCommand((SolrQueryRequest)this.makeSolrQueryRequest());
        cmd.id = uri;
        try {
            if (this.isCloud()) {
                this.deleteCloud(cmd);
            } else {
                this.core.getUpdateHandler().delete(cmd);
            }
        }
        catch (IOException e) {
            throw new LuxException(e);
        }
    }

    private void deleteCloud(DeleteUpdateCommand cmd) throws IOException {
        UpdateRequestProcessorChain updateChain = this.xqueryComponent.getCore().getUpdateProcessingChain("lux-update-chain");
        SolrQueryResponse rsp = new SolrQueryResponse();
        SolrQueryRequest req = UpdateDocCommand.makeSolrRequest(this.core);
        UpdateRequestProcessor processor = updateChain.createProcessor(req, rsp);
        processor.processDelete(cmd);
        processor.finish();
    }

    @Override
    public void deleteAll() {
        DeleteUpdateCommand cmd = new DeleteUpdateCommand((SolrQueryRequest)this.makeSolrQueryRequest());
        cmd.query = "*:*";
        try {
            if (this.isCloud()) {
                this.deleteCloud(cmd);
            } else {
                this.core.getUpdateHandler().deleteByQuery(cmd);
            }
        }
        catch (IOException e) {
            throw new LuxException(e);
        }
    }

    private SolrQueryRequestBase makeSolrQueryRequest() {
        return new SolrQueryRequestBase(this.core, (SolrParams)new ModifiableSolrParams()){};
    }

    @Override
    public void commit(Evaluator eval) {
        SolrQueryContext context = (SolrQueryContext)eval.getQueryContext();
        context.setCommitPending(true);
    }

    @Override
    public void close(Evaluator eval) {
        this.commit(eval);
    }

    private boolean isCloud() {
        return this.xqueryComponent.getCurrentShards() != null;
    }
}

