/*
 * Decompiled with CFR 0.152.
 */
package lux.solr;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import lux.Compiler;
import lux.exception.LuxException;
import lux.index.FieldRole;
import lux.index.IndexConfiguration;
import lux.index.XmlIndexer;
import lux.index.analysis.DefaultAnalyzer;
import lux.index.analysis.WhitespaceGapAnalyzer;
import lux.index.field.FieldDefinition;
import lux.index.field.XPathField;
import lux.index.field.XmlTextField;
import net.sf.saxon.s9api.Serializer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.document.Field;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.schema.BinaryField;
import org.apache.solr.schema.CopyField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrField;
import org.apache.solr.schema.TextField;
import org.apache.solr.schema.TrieIntField;
import org.apache.solr.schema.TrieLongField;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrIndexConfig
implements SolrInfoMBean {
    private static final String SOURCE_URL = "https://github.com/msokolov/lux";
    private final IndexConfiguration indexConfig;
    private NamedList<String> xpathFieldConfig;
    private Compiler compiler;
    private ArrayBlockingQueue<XmlIndexer> indexerPool;
    private ArrayBlockingQueue<Serializer> serializerPool;
    private IndexSchema schema;
    private final Logger logger;
    private static URL[] docs;

    public SolrIndexConfig(IndexConfiguration indexConfig, NamedList<?> args) {
        this.indexConfig = indexConfig;
        this.indexerPool = new ArrayBlockingQueue(8);
        this.serializerPool = new ArrayBlockingQueue(8);
        this.logger = LoggerFactory.getLogger(this.getClass());
        if (args != null) {
            this.applySolrConfig(args);
        }
        this.compiler = new Compiler(indexConfig);
    }

    public Compiler getCompiler() {
        return this.compiler;
    }

    public XmlIndexer checkoutXmlIndexer() {
        XmlIndexer indexer = this.indexerPool.poll();
        if (indexer == null) {
            indexer = new XmlIndexer(this.indexConfig, this.compiler);
            this.logger.debug("created new XmlIndexer");
        }
        return indexer;
    }

    public void returnXmlIndexer(XmlIndexer doneWithIt) {
        this.indexerPool.offer(doneWithIt);
    }

    public Serializer checkoutSerializer() {
        Serializer serializer = this.serializerPool.poll();
        if (serializer == null) {
            serializer = new Serializer();
            serializer.setOutputProperty(Serializer.Property.ENCODING, "utf-8");
            serializer.setOutputProperty(Serializer.Property.BYTE_ORDER_MARK, "no");
            serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
        }
        return serializer;
    }

    public void returnSerializer(Serializer doneWithIt) {
        this.serializerPool.offer(doneWithIt);
    }

    public static SolrIndexConfig registerIndexConfiguration(SolrCore core) {
        SolrIndexConfig indexConfig;
        NamedList initArgs = null;
        for (PluginInfo info : core.getSolrConfig().getPluginInfos(UpdateRequestProcessorChain.class.getName())) {
            initArgs = info.initArgs;
            if (!"true".equals(info.attributes.get("default"))) continue;
            break;
        }
        String configName = SolrIndexConfig.class.getName();
        SolrInfoMBean configBean = (SolrInfoMBean)core.getInfoRegistry().get(configName);
        if (configBean != null) {
            indexConfig = (SolrIndexConfig)configBean;
        } else {
            int options = 202;
            indexConfig = SolrIndexConfig.makeIndexConfiguration(options, initArgs, configName);
            indexConfig.inform(core);
            core.getInfoRegistry().put(configName, indexConfig);
        }
        return indexConfig;
    }

    public static SolrIndexConfig makeIndexConfiguration(int options, NamedList<?> args, String configName) {
        if (args != null) {
            Object format;
            if ("yes".equals(args.get("strip-namespaces"))) {
                options |= 0x400;
            }
            if ("yes".equals(args.get("namespace-aware"))) {
                options |= 4;
            }
            if ((format = args.get("xml-format")) != null) {
                if ("tiny".equals(format)) {
                    options |= 0x10;
                } else if (!"xml".equals(format)) {
                    throw new LuxException("invalid xml-format: " + format + ", must be one of: (xml,tiny)");
                }
            }
        }
        IndexConfiguration indexConfig = new IndexConfiguration(options);
        return new SolrIndexConfig(indexConfig, args);
    }

    public void applyFieldConfiguration(NamedList<String> fields) {
        if (fields != null) {
            this.xpathFieldConfig = new NamedList();
            for (Map.Entry f : fields) {
                this.xpathFieldConfig.add((String)f.getKey(), f.getValue());
            }
        }
    }

    private void applySolrConfig(NamedList args) {
        NamedList namespaces;
        NamedList aliases = (NamedList)args.get("fieldAliases");
        if (aliases == null) {
            return;
        }
        for (int i = 0; i < aliases.size(); ++i) {
            String name = aliases.getName(i);
            Object value = aliases.getVal(i);
            if ("xmlFieldName".equals(name)) {
                this.indexConfig.renameField(this.indexConfig.getField(FieldRole.XML_STORE), value.toString());
                this.logger.info("XML storage field name: {}", (Object)value.toString());
                continue;
            }
            if ("uriFieldName".equals(name)) {
                this.logger.info("URI field name: {}", (Object)value.toString());
                this.indexConfig.renameField(this.indexConfig.getField(FieldRole.URI), value.toString());
                continue;
            }
            if (!"textFieldName".equals(name)) continue;
            this.logger.info("XML text field name: {}", (Object)value.toString());
            this.indexConfig.renameField(this.indexConfig.getField(FieldRole.XML_TEXT), value.toString());
        }
        NamedList fields = (NamedList)args.get("fields");
        if (fields != null) {
            this.applyFieldConfiguration((NamedList<String>)fields);
        }
        if ((namespaces = (NamedList)args.get("namespaces")) != null) {
            for (Map.Entry ns : namespaces) {
                this.indexConfig.defineNamespaceMapping((String)ns.getKey(), (String)ns.getValue());
            }
        }
    }

    public void inform(SolrCore core) {
        SchemaField uniqueKeyField;
        this.schema = core.getLatestSchema();
        this.informField(this.indexConfig.getField(FieldRole.XML_STORE), core);
        this.registerXmlTextFields();
        for (FieldDefinition xmlField : this.indexConfig.getFields()) {
            this.informField(xmlField, core);
        }
        if (this.xpathFieldConfig != null) {
            this.addXPathFields();
        }
        if ((uniqueKeyField = this.schema.getUniqueKeyField()) == null) {
            this.logger.error("{} schema does not define any unique field", (Object)core.getName());
        } else if (!uniqueKeyField.getName().equals(this.indexConfig.getFieldName(FieldRole.URI))) {
            this.logger.error("{} schema defines a different unique field than the uri field declared in lux configuration", (Object)core.getName());
        }
        this.schema.refreshAnalyzers();
    }

    private void informField(FieldDefinition xmlField, SolrCore core) {
        Map schemaFields = this.schema.getFields();
        Map fieldTypes = this.schema.getFieldTypes();
        String fieldName = xmlField.getName();
        if (schemaFields.containsKey(fieldName) && xmlField.getType() != FieldDefinition.Type.TOKENS) {
            return;
        }
        FieldType fieldType = this.getFieldType(xmlField);
        if (!fieldTypes.containsKey(fieldType.getTypeName())) {
            this.logger.info("{} defining fieldType: {}", (Object)core.getName(), (Object)fieldType.getTypeName());
            fieldTypes.put(fieldType.getTypeName(), fieldType);
        } else {
            fieldType = (FieldType)fieldTypes.get(fieldType.getTypeName());
        }
        this.logger.info(core.getName() + " defining field: {} of type {}", (Object)fieldName, (Object)fieldType.getTypeName());
        schemaFields.put(fieldName, new SchemaField(fieldName, fieldType, xmlField.getSolrFieldProperties(), ""));
    }

    private void registerXmlTextFields() {
        String xmlFieldName = this.indexConfig.getFieldName(FieldRole.XML_TEXT);
        SchemaField schemaField = this.schema.getFieldOrNull(xmlFieldName);
        Analyzer xmlAnalyzer = null;
        if (schemaField != null && (xmlAnalyzer = schemaField.getType().getAnalyzer()) != null) {
            for (FieldRole role : new FieldRole[]{FieldRole.XML_TEXT, FieldRole.ELEMENT_TEXT, FieldRole.ATTRIBUTE_TEXT}) {
                FieldDefinition field = this.indexConfig.getField(role);
                field.setAnalyzer(xmlAnalyzer);
                this.indexConfig.getFieldAnalyzers().put(field.getName(), xmlAnalyzer);
            }
        }
        for (CopyField copyField : this.schema.getCopyFieldsList(xmlFieldName)) {
            SchemaField destination = copyField.getDestination();
            Object analyzer = destination.getType().getAnalyzer();
            if (analyzer == null) {
                analyzer = xmlAnalyzer != null ? xmlAnalyzer : new DefaultAnalyzer();
            }
            XmlTextField xmlCopyField = new XmlTextField(destination.getName(), (Analyzer)analyzer);
            this.indexConfig.addField(xmlCopyField);
        }
    }

    private void addXPathFields() {
        for (Map.Entry f : this.xpathFieldConfig) {
            SchemaField field = this.schema.getField((String)f.getKey());
            FieldType fieldType = field.getType();
            if (fieldType == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Field " + (String)f.getKey() + " declared in lux config, but not defined in schema");
            }
            XPathField xpathField = new XPathField((String)f.getKey(), (String)f.getValue(), fieldType.getAnalyzer(), field.stored() ? Field.Store.YES : Field.Store.NO, field);
            this.indexConfig.addField(xpathField);
        }
    }

    private FieldType getFieldType(FieldDefinition xmlField) {
        Analyzer analyzer = xmlField.getAnalyzer();
        String fieldName = xmlField.getName();
        if (analyzer == null) {
            if (xmlField.isStored() != Field.Store.YES) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "invalid xml field: " + fieldName + "; no analyzer and not stored");
            }
            switch (xmlField.getType()) {
                case STRING: {
                    return new StoredStringField();
                }
                case INT: {
                    return new NamedIntField();
                }
                case LONG: {
                    return new NamedLongField();
                }
                case BYTES: {
                    return new NamedBinaryField();
                }
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "invalid stored field: " + fieldName + " with type: " + (Object)((Object)xmlField.getType()));
        }
        if (xmlField.getType() == FieldDefinition.Type.TOKENS) {
            return new FieldableField(xmlField);
        }
        if (analyzer == null || analyzer instanceof KeywordAnalyzer) {
            return new StringField();
        }
        if (analyzer instanceof WhitespaceGapAnalyzer) {
            return new PathField();
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "invalid xml field: " + fieldName + "; unknown analyzer type: " + analyzer);
    }

    public IndexSchema getSchema() {
        return this.schema;
    }

    public IndexConfiguration getIndexConfig() {
        return this.indexConfig;
    }

    public String getName() {
        return SolrIndexConfig.class.getName();
    }

    public String getVersion() {
        return "1.0";
    }

    public String getDescription() {
        return "Lux index configuration";
    }

    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.OTHER;
    }

    public String getSource() {
        return SOURCE_URL;
    }

    public URL[] getDocs() {
        if (docs == null) {
            try {
                docs = new URL[]{new URL(SOURCE_URL)};
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return docs;
    }

    public NamedList<?> getStatistics() {
        return null;
    }

    class FieldableField
    extends TextField {
        FieldableField(FieldDefinition xmlField) {
            this.typeName = xmlField.getName() + "-fieldable-type";
            this.analyzer = xmlField.getAnalyzer();
            this.queryAnalyzer = xmlField.getAnalyzer();
        }

        public Field createField(SchemaField field, Object val, float boost) {
            return (Field)val;
        }
    }

    class PathField
    extends TextField {
        PathField() {
            this.typeName = "lux_text_ws";
            this.setAnalyzer(new WhitespaceGapAnalyzer());
            this.setQueryAnalyzer(new WhitespaceGapAnalyzer());
        }
    }

    class StringField
    extends StrField {
        StringField() {
            this.typeName = "string";
        }
    }

    class NamedBinaryField
    extends BinaryField {
        public NamedBinaryField() {
            this.typeName = "binary";
        }
    }

    class NamedLongField
    extends TrieLongField {
        public NamedLongField() {
            this.typeName = "long";
        }
    }

    class NamedIntField
    extends TrieIntField {
        public NamedIntField() {
            this.typeName = "int";
        }
    }

    class StoredStringField
    extends StrField {
        StoredStringField() {
            this.typeName = "lux_stored_string";
        }
    }
}

