/*
 * Decompiled with CFR 0.152.
 */
package lux.solr;

import java.util.ArrayList;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import lux.CachingDocReader;
import lux.LuxURIResolver;
import lux.exception.LuxException;
import lux.exception.NotFoundException;
import lux.index.FieldRole;
import lux.index.IndexConfiguration;
import lux.search.LuxSearcher;
import lux.solr.CloudQueryRequest;
import lux.solr.XQueryComponent;
import net.sf.saxon.s9api.XdmNode;
import org.apache.lucene.search.Sort;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.SortSpec;

public class SolrURIResolver
extends LuxURIResolver {
    private final XQueryComponent xqueryComponent;
    private final String xmlFieldName;
    private final String idFieldName;

    SolrURIResolver(XQueryComponent xqueryComponent, URIResolver systemURIResolver) {
        super(systemURIResolver, null, xqueryComponent.getSolrIndexConfig().getIndexConfig().getFieldName(FieldRole.URI));
        this.xqueryComponent = xqueryComponent;
        IndexConfiguration indexConfig = xqueryComponent.getSolrIndexConfig().getIndexConfig();
        this.xmlFieldName = indexConfig.getFieldName(FieldRole.XML_STORE);
        this.idFieldName = indexConfig.getFieldName(FieldRole.ID);
    }

    @Override
    public XdmNode getDocument(String uri) throws TransformerException {
        String[] shards = this.xqueryComponent.getCurrentShards();
        if (shards != null) {
            return this.getDocumentDistrib(uri);
        }
        return super.getDocument(uri);
    }

    private XdmNode getDocumentDistrib(String uri) throws NotFoundException {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.add("q", new String[]{this.uriFieldName + ":\"" + uri.replaceAll("([\\\\\\\"])", "\\$1") + '\"'});
        params.add("fl", new String[]{this.uriFieldName, this.xmlFieldName, this.idFieldName});
        params.add("wt", new String[]{"javabin"});
        params.add("version", new String[]{"2"});
        params.add("distrib", new String[]{"true"});
        String[] shards = this.xqueryComponent.getCurrentShards();
        StringBuilder shardBuffer = new StringBuilder(shards[0]);
        for (int i = 0; i < shards.length; ++i) {
            shardBuffer.append(',').append(shards[i]);
        }
        params.add("shards", new String[]{shardBuffer.toString()});
        CloudQueryRequest req = new CloudQueryRequest(this.xqueryComponent.getCore(), (SolrParams)params, new SortSpec(Sort.RELEVANCE, 1));
        req.setNextStage(ResponseBuilder.STAGE_GET_FIELDS);
        SolrQueryResponse response = new SolrQueryResponse();
        this.xqueryComponent.getSearchHandler().handleRequest((SolrQueryRequest)req, response);
        if (response.getException() != null) {
            throw new LuxException("An error occurred while retrieving " + uri, response.getException());
        }
        SolrDocumentList docs = (SolrDocumentList)response.getValues().get("response");
        if (docs.isEmpty()) {
            throw new NotFoundException("document '" + uri + "' not found");
        }
        if (docs.size() > 1) {
            throw new NotFoundException("found " + docs.size() + " documents with uri='" + uri + "'");
        }
        SolrDocument doc = (SolrDocument)docs.get(0);
        Long docID = (Long)doc.get((Object)this.idFieldName);
        Object xml = doc.get((Object)this.xmlFieldName);
        if (xml instanceof ArrayList) {
            xml = ((ArrayList)xml).get(0);
        }
        String xmlString = null;
        byte[] xmlBytes = null;
        if (xml instanceof String) {
            xmlString = (String)xml;
        } else {
            xmlBytes = (byte[])xml;
        }
        XdmNode node = this.getDocReader().createXdmNode(docID, uri, xmlString, xmlBytes);
        doc.removeFields(this.xmlFieldName);
        node.getUnderlyingNode().getDocumentRoot().setUserData(SolrDocument.class.getName(), (Object)doc);
        return node;
    }

    @Override
    public LuxSearcher getSearcher() {
        return this.xqueryComponent.getEvaluator().getSearcher();
    }

    @Override
    public CachingDocReader getDocReader() {
        return this.xqueryComponent.getEvaluator().getDocReader();
    }
}

