/*
 * Decompiled with CFR 0.152.
 */
package lux.solr;

import java.io.IOException;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.util.BytesRef;

class TermOrdValComparator_SML
extends FieldComparator<Comparable> {
    private static final int NULL_ORD = 0x7FFFFFFE;
    private final int[] ords;
    private final BytesRef[] values;
    private final int[] readerGen;
    private SortedDocValues termsIndex;
    private final String field;
    private final BytesRef NULL_VAL;
    private PerSegmentComparator current;

    public TermOrdValComparator_SML(int numHits, String field, int sortPos, boolean reversed, BytesRef nullVal) {
        this.ords = new int[numHits];
        this.values = new BytesRef[numHits];
        this.readerGen = new int[numHits];
        this.field = field;
        this.NULL_VAL = nullVal;
    }

    public int compare(int slot1, int slot2) {
        throw new UnsupportedOperationException();
    }

    public void setBottom(int slot) {
        throw new UnsupportedOperationException();
    }

    public int compareBottom(int doc) {
        throw new UnsupportedOperationException();
    }

    public void copy(int slot, int doc) {
        throw new UnsupportedOperationException();
    }

    public BytesRef value(int slot) {
        throw new UnsupportedOperationException();
    }

    public int compareValues(Comparable first, Comparable second) {
        if (first == null) {
            if (second == null) {
                return 0;
            }
            return 1;
        }
        if (second == null) {
            return -1;
        }
        return first.compareTo(second);
    }

    public FieldComparator setNextReader(AtomicReaderContext context) throws IOException {
        return TermOrdValComparator_SML.createComparator(context.reader(), this);
    }

    public int compareDocToValue(int doc, Comparable docValue) {
        throw new UnsupportedOperationException();
    }

    public static FieldComparator createComparator(AtomicReader reader, TermOrdValComparator_SML parent) throws IOException {
        parent.termsIndex = FieldCache.DEFAULT.getTermsIndex(reader, parent.field);
        AnyOrdComparator perSegComp = new AnyOrdComparator(parent);
        if (perSegComp.bottomSlot != -1) {
            perSegComp.setBottom(perSegComp.bottomSlot);
        }
        parent.current = perSegComp;
        return perSegComp;
    }

    private static final class AnyOrdComparator
    extends PerSegmentComparator {
        public AnyOrdComparator(TermOrdValComparator_SML parent) {
            super(parent);
        }

        public int compareBottom(int doc) {
            assert (this.bottomSlot != -1);
            int order = this.termsIndex.getOrd(doc);
            if (order == -1) {
                order = 0x7FFFFFFE;
            }
            if (this.bottomSameReader) {
                return this.bottomOrd - order;
            }
            int cmp = this.bottomOrd - order;
            if (cmp != 0) {
                return cmp;
            }
            if (order == 0x7FFFFFFE) {
                return 0;
            }
            if (order == 0x7FFFFFFE) {
                return this.bottomValue.compareTo(this.parent.NULL_VAL);
            }
            this.termsIndex.lookupOrd(order, this.tempBR);
            return this.bottomValue.compareTo(this.tempBR);
        }

        public void copy(int slot, int doc) {
            int ord = this.termsIndex.getOrd(doc);
            if (ord == -1) {
                this.ords[slot] = 0x7FFFFFFE;
                this.values[slot] = null;
            } else {
                this.ords[slot] = ord;
                assert (ord >= 0);
                if (this.values[slot] == null) {
                    this.values[slot] = new BytesRef();
                }
                this.termsIndex.lookupOrd(ord, this.values[slot]);
            }
            this.readerGen[slot] = this.currentReaderGen;
        }
    }

    private static abstract class PerSegmentComparator
    extends FieldComparator<BytesRef> {
        protected TermOrdValComparator_SML parent;
        protected final int[] ords;
        protected final BytesRef[] values;
        protected final int[] readerGen;
        protected int currentReaderGen = -1;
        protected SortedDocValues termsIndex;
        protected int bottomSlot = -1;
        protected int bottomOrd;
        protected boolean bottomSameReader = false;
        protected BytesRef bottomValue;
        protected final BytesRef tempBR = new BytesRef();

        public PerSegmentComparator(TermOrdValComparator_SML parent) {
            this.parent = parent;
            PerSegmentComparator previous = parent.current;
            if (previous != null) {
                this.currentReaderGen = previous.currentReaderGen;
                this.bottomSlot = previous.bottomSlot;
                this.bottomOrd = previous.bottomOrd;
                this.bottomValue = previous.bottomValue;
            }
            this.ords = parent.ords;
            this.values = parent.values;
            this.readerGen = parent.readerGen;
            this.termsIndex = parent.termsIndex;
            ++this.currentReaderGen;
        }

        public FieldComparator setNextReader(AtomicReaderContext context) throws IOException {
            return TermOrdValComparator_SML.createComparator(context.reader(), this.parent);
        }

        public int compare(int slot1, int slot2) {
            if (this.readerGen[slot1] == this.readerGen[slot2]) {
                return this.ords[slot1] - this.ords[slot2];
            }
            BytesRef val1 = this.values[slot1];
            BytesRef val2 = this.values[slot2];
            if (val1 == null) {
                if (val2 == null) {
                    return 0;
                }
                return 1;
            }
            if (val2 == null) {
                return -1;
            }
            return val1.compareTo(val2);
        }

        public void setBottom(int bottom) {
            this.bottomSlot = bottom;
            this.bottomValue = this.values[this.bottomSlot];
            if (this.currentReaderGen == this.readerGen[this.bottomSlot]) {
                this.bottomOrd = this.ords[this.bottomSlot];
                this.bottomSameReader = true;
            } else if (this.bottomValue == null) {
                assert (this.ords[this.bottomSlot] == 0x7FFFFFFE);
                this.bottomOrd = 0x7FFFFFFE;
                this.bottomSameReader = true;
                this.readerGen[this.bottomSlot] = this.currentReaderGen;
            } else {
                int index = this.termsIndex.lookupTerm(this.bottomValue);
                if (index < 0) {
                    this.bottomOrd = -index - 2;
                    this.bottomSameReader = false;
                } else {
                    this.bottomOrd = index;
                    this.bottomSameReader = true;
                    this.readerGen[this.bottomSlot] = this.currentReaderGen;
                    this.ords[this.bottomSlot] = this.bottomOrd;
                }
            }
        }

        public BytesRef value(int slot) {
            return this.values == null ? this.parent.NULL_VAL : this.values[slot];
        }

        public int compareDocToValue(int doc, BytesRef value) {
            int docOrd = this.termsIndex.getOrd(doc);
            if (docOrd == -1) {
                if (value == null) {
                    return 0;
                }
                return 1;
            }
            if (value == null) {
                return -1;
            }
            this.termsIndex.lookupOrd(docOrd, this.tempBR);
            return this.tempBR.compareTo(value);
        }
    }
}

