/*
 * Decompiled with CFR 0.152.
 */
package lux.solr;

import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import lux.query.parser.XmlQueryParser;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.queryparser.xml.ParserException;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SyntaxError;

public class XmlQParserPlugin
extends QParserPlugin {
    public void init(NamedList args) {
    }

    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new XmlQParser(qstr, localParams, params, req);
    }

    class XmlQParser
    extends QParser {
        private XmlQueryParser xmlParser;

        public XmlQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
            super(qstr, localParams, params, req);
        }

        public Query parse() throws SyntaxError {
            if (this.qstr == null || this.qstr.length() == 0) {
                return null;
            }
            String defaultField = this.getParam("df");
            if (defaultField == null) {
                defaultField = this.getReq().getSchema().getDefaultSearchFieldName();
            }
            this.xmlParser = new XmlQueryParser(defaultField, (Analyzer)new StandardAnalyzer(this.req.getCore().getSolrConfig().luceneMatchVersion));
            try {
                return this.xmlParser.parse(new ByteArrayInputStream(this.qstr.getBytes(Charset.forName("utf-8"))));
            }
            catch (ParserException e) {
                throw new SyntaxError((Throwable)e);
            }
        }
    }
}

