/*
 * Decompiled with CFR 0.152.
 */
package lux.xpath;

import lux.xml.QName;
import lux.xml.ValueType;
import lux.xpath.AbstractExpression;
import lux.xpath.ExpressionVisitor;
import lux.xpath.LiteralExpression;

public class FunCall
extends AbstractExpression {
    public static final String LUX_NAMESPACE = "http://luxdb.net";
    private final QName name;
    private final ValueType returnType;
    public static final QName LUX_SEARCH = new QName("http://luxdb.net", "search", "lux");
    public static final QName LUX_COUNT = new QName("http://luxdb.net", "count", "lux");
    public static final QName LUX_EXISTS = new QName("http://luxdb.net", "exists", "lux");
    public static final QName LUX_KEY = new QName("http://luxdb.net", "key", "lux");
    public static final QName LUX_FIELD_VALUES = new QName("http://luxdb.net", "field-values", "lux");
    public static final String FN_NAMESPACE = "http://www.w3.org/2005/xpath-functions";
    public static final QName FN_ROOT = new QName("http://www.w3.org/2005/xpath-functions", "root", "fn");
    public static final QName FN_LAST = new QName("http://www.w3.org/2005/xpath-functions", "last", "fn");
    public static final QName FN_DATA = new QName("http://www.w3.org/2005/xpath-functions", "data", "fn");
    public static final QName FN_UNORDERED = new QName("http://www.w3.org/2005/xpath-functions", "unordered", "fn");
    public static final QName FN_SUBSEQUENCE = new QName("http://www.w3.org/2005/xpath-functions", "subsequence", "fn");
    public static final QName FN_COUNT = new QName("http://www.w3.org/2005/xpath-functions", "count", "fn");
    public static final QName FN_EXISTS = new QName("http://www.w3.org/2005/xpath-functions", "exists", "fn");
    public static final QName FN_NOT = new QName("http://www.w3.org/2005/xpath-functions", "not", "fn");
    public static final QName FN_EMPTY = new QName("http://www.w3.org/2005/xpath-functions", "empty", "fn");
    public static final QName FN_COLLECTION = new QName("http://www.w3.org/2005/xpath-functions", "collection", "fn");
    public static final QName FN_STRING_JOIN = new QName("http://www.w3.org/2005/xpath-functions", "string-join", "fn");
    public static final QName FN_CONTAINS = new QName("http://www.w3.org/2005/xpath-functions", "contains", "fn");
    public static final QName FN_MIN = new QName("http://www.w3.org/2005/xpath-functions", "min", "fn");
    public static final QName FN_MAX = new QName("http://www.w3.org/2005/xpath-functions", "max", "fn");
    public static final String LOCAL_NAMESPACE = "http://www.w3.org/2005/xquery-local-functions";
    public static final String XS_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    public static final FunCall LastExpression = new FunCall(FN_LAST, ValueType.VALUE, new AbstractExpression[0]);

    public FunCall(QName name, ValueType returnType, AbstractExpression ... arguments) {
        super(AbstractExpression.Type.FUNCTION_CALL);
        this.name = name;
        this.setSubs(arguments);
        this.returnType = returnType;
    }

    public void setArguments(AbstractExpression ... args) {
        this.setSubs(args);
    }

    @Override
    public void toString(StringBuilder buf) {
        buf.append(this.name);
        buf.append('(');
        if (this.subs.length == 1) {
            buf.append(this.subs[0]);
        } else if (this.subs.length > 1) {
            this.subs[0].toString(buf);
        }
        for (int i = 1; i < this.subs.length; ++i) {
            buf.append(',');
            this.subs[i].toString(buf);
        }
        buf.append(')');
    }

    public QName getName() {
        return this.name;
    }

    @Override
    public int getPrecedence() {
        return 100;
    }

    @Override
    public AbstractExpression accept(ExpressionVisitor visitor) {
        super.acceptSubs(visitor);
        return visitor.visit(this);
    }

    public ValueType getReturnType() {
        return this.returnType;
    }

    @Override
    public boolean isDocumentOrdered() {
        if (this.returnType.isAtomic) {
            return false;
        }
        if (this.name.getNamespaceURI().equals(LUX_NAMESPACE) && this.name.getLocalPart().equals("search")) {
            AbstractExpression sortExpr;
            return this.getSubs().length > 1 && (sortExpr = this.getSubs()[1]) instanceof LiteralExpression && ((LiteralExpression)sortExpr).getValue().equals("lux:docid");
        }
        if (this.name.getNamespaceURI().equals(FN_NAMESPACE)) {
            if (this.name.getLocalPart().equals("reverse") || this.name.getLocalPart().equals("unordered")) {
                return false;
            }
            if (this.name.getLocalPart().equals("root")) {
                return false;
            }
            return super.isDocumentOrdered();
        }
        return false;
    }

    @Override
    public AbstractExpression getLastContextStep() {
        if (this.name.getNamespaceURI().equals(XS_NAMESPACE) || this.name.getNamespaceURI().equals(FN_NAMESPACE) && this.name.getLocalPart().equals("data")) {
            return this.subs[0].getLastContextStep();
        }
        return this;
    }

    @Override
    public AbstractExpression getRoot() {
        if (this.name.equals(LUX_SEARCH)) {
            return this;
        }
        if (this.name.equals(FN_UNORDERED) || this.name.equals(FN_SUBSEQUENCE)) {
            return this.getSubs()[0].getRoot();
        }
        return null;
    }

    @Override
    public boolean propEquals(AbstractExpression other) {
        return this.name.equals(((FunCall)other).name) && this.returnType.equals((Object)((FunCall)other).returnType);
    }

    @Override
    public int equivHash() {
        return 43 + this.returnType.ordinal() + this.name.hashCode();
    }

    @Override
    public boolean isRestrictive() {
        return this.name.equals(FN_ROOT) || this.name.equals(FN_DATA) || this.name.equals(FN_EXISTS);
    }
}

