/*
 * Decompiled with CFR 0.152.
 */
package lux.xquery;

import lux.xpath.AbstractExpression;
import lux.xpath.ExpressionVisitor;
import lux.xquery.FLWORClause;
import lux.xquery.WhereClause;

public class FLWOR
extends AbstractExpression {
    private final FLWORClause[] clauses;

    public FLWOR(AbstractExpression returnExpression, FLWORClause ... clauses) {
        super(AbstractExpression.Type.FLWOR);
        this.clauses = clauses;
        this.subs = new AbstractExpression[]{returnExpression};
    }

    @Override
    public AbstractExpression accept(ExpressionVisitor visitor) {
        for (int i = 0; i < this.clauses.length; ++i) {
            this.clauses[i].accept(visitor);
        }
        this.subs[0] = this.getReturnExpression().accept(visitor);
        return visitor.visit(this);
    }

    @Override
    public void toString(StringBuilder buf) {
        boolean inWhereClause = false;
        for (FLWORClause clause : this.clauses) {
            if (clause instanceof WhereClause) {
                if (inWhereClause) {
                    buf.append("and ");
                    clause.getSequence().toString(buf);
                } else {
                    inWhereClause = true;
                    clause.toString(buf);
                }
            } else {
                clause.toString(buf);
            }
            buf.append("\n ");
        }
        buf.append("return ");
        this.getReturnExpression().toString(buf);
        buf.append("\n");
    }

    public AbstractExpression getReturnExpression() {
        return this.subs[0];
    }

    public FLWORClause[] getClauses() {
        return this.clauses;
    }

    @Override
    public AbstractExpression replaceRoot(AbstractExpression replacement) {
        super.replaceRoot(replacement);
        for (FLWORClause clause : this.clauses) {
            clause.getSequence().replaceRoot(replacement);
        }
        return this;
    }

    @Override
    public AbstractExpression getRoot() {
        return this.getReturnExpression().getRoot();
    }

    @Override
    public int getPrecedence() {
        return 3;
    }

    @Override
    public AbstractExpression getLastContextStep() {
        return this.getReturnExpression().getLastContextStep();
    }
}

