/*
 * Decompiled with CFR 0.152.
 */
package lux.xquery;

import lux.xpath.AbstractExpression;
import lux.xquery.Variable;
import lux.xquery.VariableContext;

public class VariableDefinition
implements Comparable<VariableDefinition>,
VariableContext {
    private final Variable variable;
    private final AbstractExpression value;
    private final String typeDesc;
    private final int order;

    public VariableDefinition(Variable var, AbstractExpression value, String typeDesc, int order) {
        this.variable = var;
        this.value = value;
        this.typeDesc = typeDesc;
        this.order = order;
        var.setBindingContext(this);
    }

    public void toString(StringBuilder buf) {
        buf.append("declare variable ");
        this.variable.toString(buf);
        if (this.typeDesc != null) {
            buf.append(" as ").append(this.typeDesc);
        }
        if (this.value == null) {
            buf.append(" external;\n");
        } else {
            buf.append(" := ");
            this.value.toString(buf);
            buf.append(";\n");
        }
    }

    @Override
    public int compareTo(VariableDefinition o) {
        return this.order - o.order;
    }
}

