package org.lwapp.commons;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name = "PropertyList")
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PropertyList", propOrder = { "name", "properties" })
public class PropertyList implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private String name;
	private final List<Property> properties = new ArrayList<>();

	PropertyList() {
		name = null;
	}

	public PropertyList(final String name) {
		this.name = name;
	}

	public String getName() {
		return name;
	}

	public void setName(final String name) {
		this.name = name;
	}

	public List<Property> getProperties() {
		return properties;
	}

	public void addValues(final List<Property> values) {
		this.properties.addAll(values);
	}

	public void addProperty(final Property value) {
		this.properties.add(value);
	}

}
