package org.lwapp.commons.cli;

import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

import jline.console.ConsoleReader;

public final class Terminal {

	private final BufferedReader in;
	private final PrintStream out;

	public Terminal(final PrintStream ps, final InputStream inputStream) {
		in = new BufferedReader(new InputStreamReader(inputStream));
		out = ps;
	}

	public String readString(final String prompt) {
		print(prompt);
		try {
			return in.readLine();
		} catch (final IOException e) {
			throw new RuntimeException(e);
		}
	}

	public void println(final String prompt) {
		out.println(prompt);
	}

	public void print(final String prompt) {
		out.print(prompt + "\t");
	}

	public String readPassword(final String prompt) {
		final Console console = System.console();
		if (console == null) {
			try {
				return new ConsoleReader().readLine(prompt, new Character(' '));
			} catch (final IOException e) {
				throw new RuntimeException(e);
			}
		} else {
			return new String(console.readPassword(prompt));
		}
	}
}
