/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.commons;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.lwapp.commons.IdentityType;
import org.lwapp.commons.utils.EmailValidator;

public final class Identity
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String IDENTITY_REG_EXP = "^([\\x00-\\x7F]+:[a-zA-Z]+$)";
    private final String id;
    private final IdentityType identityType;

    private Identity(String id, IdentityType identityType) {
        if (StringUtils.isBlank((CharSequence)id) || identityType == null) {
            throw new IllegalArgumentException("Invalid Identity or IdentityType missing.");
        }
        this.id = id;
        this.identityType = identityType;
        if (!this.toString().matches(IDENTITY_REG_EXP)) {
            throw new RuntimeException("Invalid Identity");
        }
    }

    public static Identity createIdentity(String identity, IdentityType type) {
        if (StringUtils.isBlank((CharSequence)identity)) {
            throw new IllegalArgumentException("Identity is missing");
        }
        if (type == null) {
            throw new IllegalArgumentException("IdentityType is missing");
        }
        Identity.validate(identity, type);
        return new Identity(identity, type);
    }

    private static void validate(String identity, IdentityType type) {
        switch (type) {
            case EMAIL: {
                if (EmailValidator.isValid(identity)) break;
                throw new IllegalArgumentException("Invalid email identity.");
            }
            case MSISDN: {
                for (int i = 0; i < identity.length(); ++i) {
                    if (Character.isDigit(identity.charAt(i))) continue;
                    throw new IllegalArgumentException("Invalid msisdn identity.");
                }
                break;
            }
        }
    }

    public static Identity createMsisdnIdentity(String msisdn) {
        return Identity.createIdentity(msisdn, IdentityType.MSISDN);
    }

    public static Identity createUidIdentity(String id) {
        return Identity.createIdentity(id, IdentityType.UID);
    }

    public static Identity createEmailIdentity(String email) {
        return Identity.createIdentity(email, IdentityType.EMAIL);
    }

    public static Identity createExternalIdentity(String extId) {
        return Identity.createIdentity(extId, IdentityType.EXT);
    }

    public static Identity createUsernameIdentity(String username) {
        return Identity.createIdentity(username, IdentityType.USERNAME);
    }

    public static Identity createMachineIdentity(String machineName) {
        return Identity.createIdentity(machineName, IdentityType.MACHINE);
    }

    public static Identity createIdentity(String identityString) {
        Validate.notBlank((CharSequence)identityString, (String)"Identity is missing", (Object[])new Object[0]);
        String[] identityArray = identityString.split(":");
        Validate.isTrue((identityArray.length == 2 ? 1 : 0) != 0, (String)("Invalid identity:" + identityString + ". Expected format:- <email>:EMAIL, <msisdn>:MSISDN etc. Valid types: " + IdentityType.values()), (Object[])new Object[0]);
        String identity = identityArray[0];
        String identityType = identityArray[1];
        Validate.isTrue((boolean)IdentityType.isValidIdentityType(identityType), (String)("Invalid identity type :" + identityType + ". Valid types are:" + IdentityType.values()), (Object[])new Object[0]);
        return Identity.createIdentity(identity, IdentityType.valueOf(identityType));
    }

    public String getId() {
        return this.id;
    }

    public IdentityType getIdentityType() {
        return this.identityType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.identityType == null ? 0 : this.identityType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Identity other = (Identity)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return this.identityType == other.identityType;
    }

    public String toString() {
        return this.id + ":" + this.identityType.name();
    }
}

