/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.commons.cli;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.lwapp.commons.cli.AbstractCommand;
import org.lwapp.commons.cli.Cli;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CliBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(CliBuilder.class);
    private final Map<String, AbstractCommand> commandsMap = new HashMap<String, AbstractCommand>();

    public Cli createCli() {
        return new Cli(this.commandsMap);
    }

    public void addCommands(AbstractCommand ... commands) {
        Validate.notNull((Object)commands, (String)"Commands is mandatory.", (Object[])new Object[0]);
        for (AbstractCommand command : commands) {
            Validate.notNull((Object)command, (String)"Command is null.", (Object[])new Object[0]);
            String commandName = command.getCommandName();
            if (this.commandsMap.containsKey(commandName)) {
                throw new IllegalArgumentException("Duplicate command registered under '" + commandName + "' command.");
            }
            LOG.debug("Cli command '{}' registered.", (Object)commandName);
            this.commandsMap.put(commandName, command);
        }
    }
}

