/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.commons.cli;

import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import jline.console.ConsoleReader;

public final class Terminal {
    private final BufferedReader in;
    private final PrintStream out;

    public Terminal(PrintStream ps, InputStream inputStream) {
        this.in = new BufferedReader(new InputStreamReader(inputStream));
        this.out = ps;
    }

    public String readString(String prompt) {
        this.print(prompt);
        try {
            return this.in.readLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void println(String prompt) {
        this.out.println(prompt);
    }

    public void print(String prompt) {
        this.out.print(prompt + "\t");
    }

    public String readPassword(String prompt) {
        Console console = System.console();
        if (console == null) {
            try {
                return new ConsoleReader().readLine(prompt, new Character(' '));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new String(console.readPassword(prompt, new Object[0]));
    }
}

