/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.commons.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.InvalidPropertiesFormatException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.lwapp.commons.file.Manifest;

public final class ManifestFile {
    public final Properties properties = new Properties();

    public void addProperty(Manifest mf, Serializable value) {
        if (mf == null) {
            throw new NullPointerException("Manifest is mandatory.");
        }
        if (value != null) {
            this.properties.setProperty(mf.property, value.toString());
        }
    }

    public String getProperty(Manifest mf) {
        return this.properties.getProperty(mf.property);
    }

    public void load(InputStream in) throws InvalidPropertiesFormatException, IOException {
        this.properties.load(in);
    }

    public String toString() {
        return this.properties.toString();
    }

    public static ManifestFile getInstance() {
        return new ManifestFile();
    }

    public ManifestFile setSha512(String sha512Hash) {
        this.addProperty(Manifest.SHA512, (Serializable)((Object)sha512Hash));
        return this;
    }

    public ManifestFile setManifestVersion(String version) {
        this.addProperty(Manifest.MANIFEST_VERSION, (Serializable)((Object)version));
        return this;
    }

    public ManifestFile setDataFileName(File dataFile) {
        this.addProperty(Manifest.DATA_FILENAME, (Serializable)((Object)dataFile.getName()));
        return this;
    }

    public ManifestFile setCompressed(boolean compressed) {
        this.addProperty(Manifest.IS_COMPRESSED, Boolean.valueOf(compressed));
        return this;
    }

    public ManifestFile setEncrypted(boolean encrypted) {
        this.addProperty(Manifest.IS_ENCRYPTED, Boolean.valueOf(encrypted));
        return this;
    }

    public ManifestFile setTotalBytes(int length) {
        this.addProperty(Manifest.TOTAL_BYTES, Integer.valueOf(length));
        return this;
    }

    public ManifestFile setApplicationSystemIdentity(String applicationId) {
        this.addProperty(Manifest.APPLICATION_IDENTITY, (Serializable)((Object)applicationId));
        return this;
    }

    public ManifestFile setTotalBytesWritten(int length) {
        this.addProperty(Manifest.TOTAL_BYTESWRITTEN, Integer.valueOf(length));
        return this;
    }

    public ManifestFile setCompressedBZIP2FileName(File compressedBZIP2File) {
        this.addProperty(Manifest.COMPRESSED_BZIP2_FILENAME, (Serializable)((Object)compressedBZIP2File.getName()));
        return this;
    }

    public ManifestFile setChecksum(long checksum) {
        this.addProperty(Manifest.CHECKSUM, Long.valueOf(checksum));
        return this;
    }

    public ManifestFile setManifestFileName(File mfFile) {
        this.addProperty(Manifest.MANIFEST_FILENAME, (Serializable)((Object)mfFile.getName()));
        return this;
    }

    public ManifestFile setInboxFolder(File folder) {
        this.addProperty(Manifest.FOLDER_NAME, (Serializable)((Object)folder.getAbsolutePath()));
        return this;
    }

    public ManifestFile setCreatedDate(Date date) {
        this.addProperty(Manifest.CREATED_DATE, (Serializable)((Object)DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss")));
        return this;
    }

    public ManifestFile setProperites(Map<String, String> propertyMap) {
        if (propertyMap == null) {
            propertyMap = Collections.emptyMap();
        }
        for (Map.Entry<String, String> entry : propertyMap.entrySet()) {
            if (!this.properties.containsKey(entry.getKey())) continue;
            throw new RuntimeException("Property already set" + entry.getValue());
        }
        this.properties.putAll(propertyMap);
        return this;
    }
}

