/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.commons.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public final class CompressionUtils {
    public static final String GZ_EXT = ".gz";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File compressToGZIP(File dataFile, byte[] bytes, byte[] secret) throws Exception {
        if (bytes == null || bytes.length == 0) {
            throw new NullPointerException("Nothing to write.");
        }
        OutputStream cos = null;
        File gzipFile = new File(dataFile.getParent(), dataFile.getName() + GZ_EXT);
        try {
            OutputStream os;
            if (secret != null && secret.length > 0) {
                if (secret.length != 32) {
                    secret = StringUtils.substring((String)StringUtils.leftPad((String)new String(secret), (int)32, (String)"0"), (int)0, (int)32).getBytes();
                }
                Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
                SecretKeySpec secretKey = new SecretKeySpec(secret, "AES");
                cipher.init(1, secretKey);
                os = new CipherOutputStream(new FileOutputStream(gzipFile), cipher);
            } else {
                os = new FileOutputStream(gzipFile);
            }
            cos = new CompressorStreamFactory().createCompressorOutputStream("gz", os);
            IOUtils.write((byte[])bytes, (OutputStream)cos);
        }
        finally {
            if (cos != null) {
                cos.flush();
            }
            IOUtils.closeQuietly((OutputStream)cos);
        }
        return gzipFile;
    }

    public static byte[] deCompressGZIP(File gzipFile, byte[] secret) throws Exception {
        InputStream in;
        if (!gzipFile.exists()) {
            throw new RuntimeException("GzipFile File not exists.: " + gzipFile.getName());
        }
        if (secret != null && secret.length > 0) {
            if (secret.length != 32) {
                secret = StringUtils.substring((String)StringUtils.leftPad((String)new String(secret), (int)32, (String)"0"), (int)0, (int)32).getBytes();
            }
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            SecretKeySpec secretKey = new SecretKeySpec(secret, "AES");
            cipher.init(2, secretKey);
            in = new CipherInputStream(new FileInputStream(gzipFile), cipher);
        } else {
            in = new FileInputStream(gzipFile);
        }
        return IOUtils.toByteArray((InputStream)new GZIPInputStream(in));
    }

    public static long checksumCRC32(File file) throws Exception {
        return FileUtils.checksumCRC32((File)file);
    }
}

