/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.commons.utils;

import java.net.IDN;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EmailValidator {
    private static String ATOM = "[a-z0-9!#$%&'*+/=?^_`{|}~-]";
    private static String DOMAIN = ATOM + "+(\\." + ATOM + "+)*";
    private static String IP_DOMAIN = "\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\]";
    private static final Pattern localPattern = Pattern.compile(ATOM + "+(\\." + ATOM + "+)*", 2);
    private static final Pattern domainPattern = Pattern.compile(DOMAIN + "|" + IP_DOMAIN, 2);

    public static boolean isValid(CharSequence value) {
        if (value == null || value.length() == 0) {
            return true;
        }
        String[] emailParts = value.toString().split("@", 3);
        if (emailParts.length != 2) {
            return false;
        }
        if (emailParts[0].endsWith(".") || emailParts[1].endsWith(".")) {
            return false;
        }
        if (!EmailValidator.matchPart(emailParts[0], localPattern)) {
            return false;
        }
        return EmailValidator.matchPart(emailParts[1], domainPattern);
    }

    private static boolean matchPart(String part, Pattern pattern) {
        try {
            part = IDN.toASCII(part);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        Matcher matcher = pattern.matcher(part);
        return matcher.matches();
    }
}

