/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.commons.utils;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JMSUtils.class);

    public static Map<String, String> extractFromMapMessage(Message message) throws JMSException {
        LOG.debug("extracting MapMessage");
        if (!(message instanceof MapMessage)) {
            throw new IllegalArgumentException("JMS message must be a MapMessage");
        }
        MapMessage mapMessage = (MapMessage)message;
        if (mapMessage.propertyExists("JMS_SUN_UNCOMPRESSED_SIZE")) {
            LOG.debug("Before Compression mapMessage size '{}'", (Object)mapMessage.getIntProperty("JMS_SUN_UNCOMPRESSED_SIZE"));
        }
        if (mapMessage.propertyExists("JMS_SUN_COMPRESSED_SIZE")) {
            LOG.debug("After compression mapMessage size '{}'", (Object)mapMessage.getIntProperty("JMS_SUN_COMPRESSED_SIZE"));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration names = mapMessage.getMapNames();
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            map.put(key, mapMessage.getString(key));
        }
        return map;
    }

    public static String extractMessageText(Message message) throws JMSException {
        LOG.debug("extracting TextMessage");
        if (!(message instanceof TextMessage)) {
            throw new IllegalArgumentException("JMS message must be a TextMessage");
        }
        TextMessage textMessage = (TextMessage)message;
        if (textMessage.propertyExists("JMS_SUN_UNCOMPRESSED_SIZE")) {
            LOG.debug("Before Compression textMessage size '{}'", (Object)textMessage.getIntProperty("JMS_SUN_UNCOMPRESSED_SIZE"));
        }
        if (textMessage.propertyExists("JMS_SUN_COMPRESSED_SIZE")) {
            LOG.debug("After compression textMessage size '{}'", (Object)textMessage.getIntProperty("JMS_SUN_COMPRESSED_SIZE"));
        }
        return textMessage.getText();
    }
}

