package org.lwapp.commons;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name = "ConfigPropertyDetails")
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ConfigPropertyDetails", propOrder = { "name", "configProperty" })
public class ConfigPropertyDetails {

	private String name;
	private final List<ConfigProperty> configProperties = new ArrayList<>();

	ConfigPropertyDetails() {
		name = null;
	}

	public ConfigPropertyDetails(final String name) {
		super();
		this.name = name;
	}

	public String getName() {
		return name;
	}

	public void setName(final String name) {
		this.name = name;
	}

	public List<ConfigProperty> getConfigProperties() {
		return configProperties;
	}

	public void addConfigurations(final List<ConfigProperty> value) {
		this.configProperties.addAll(value);
	}

	public void addConfiguration(final ConfigProperty value) {
		this.configProperties.add(value);
	}

	@Override
	public String toString() {
		return "ConfigPropertyDetails [name=" + name + ", configProperties=" + configProperties + "]";
	}

}
