package org.lwapp.commons;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import org.slf4j.MDC;

@XmlRootElement(name = "ErrorResponse")
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ErrorResponse", propOrder = { "errorMessage", "logTraceId" })
public class ErrorResponse {

	private String errorMessage;
	private String logTraceId;

	@SuppressWarnings("unused")
	private ErrorResponse() {
	}

	public ErrorResponse(final String errorMessage) {
		super();
		this.errorMessage = errorMessage;
		this.logTraceId = MDC.get("logTraceId");
	}

	public String getErrorMessage() {
		return errorMessage;
	}

	public void setErrorMessage(final String errorMessage) {
		this.errorMessage = errorMessage;
	}

	public String getLogTraceId() {
		return logTraceId;
	}

	public void setLogTraceId(final String logTraceId) {
		this.logTraceId = logTraceId;
	}

}
