package org.lwapp.commons.cli;

import org.apache.commons.lang3.Validate;

public abstract class AbstractCommand implements Command {

	protected final String commandName;

	public AbstractCommand(final String commandName) {
		Validate.notBlank(commandName, "Command name is mandatory:" + getClass());
		Validate.isTrue(!commandName.contains(" "), "Command name should not contain spaces.");
		this.commandName = commandName;
	}

	public final String getCommandName() {
		return commandName;
	}

}
