package org.lwapp.commons.cli;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.commons.lang.StringUtils;

public class Cli {
	private final Map<String, AbstractCommand> commandsMap;

	public Cli(final Map<String, AbstractCommand> aCommands) {
		commandsMap = new HashMap<String, AbstractCommand>(aCommands);
	}

	public void process(final Terminal term, final String commandNameLine) {
		final String trimmedCommandLine = StringUtils.defaultString(commandNameLine).trim();
		if (StringUtils.isNotBlank(trimmedCommandLine)) {
			final String commandName = StringUtils.substringBefore(trimmedCommandLine, " ");
			if ("?".equals(commandName)) {
				printAllComands(term);
				return;
			}
			final Command command = commandsMap.get(commandName);
			if (command == null) {
				term.println("Bad command '" + commandName + "'.\n");
				printAllComands(term);
			} else {
				try {
					command.execute(term, StringUtils.substringAfter(trimmedCommandLine, " "));
				} catch (final Exception e) {
					e.printStackTrace();
				}
			}
		}
	}

	private void printAllComands(final Terminal term) {
		for (final Entry<String, AbstractCommand> entry : commandsMap.entrySet()) {
			entry.getValue().printUsage(term);
		}
	}

}
