package org.lwapp.commons.cli;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CliBuilder {
	private static final Logger LOG = LoggerFactory.getLogger(CliBuilder.class);

	private final Map<String, AbstractCommand> commandsMap = new HashMap<String, AbstractCommand>();

	public Cli createCli() {
		return new Cli(commandsMap);
	}

	public void addCommands(final AbstractCommand... commands) {
		Validate.notNull(commands, "Commands is mandatory.");
		for (final AbstractCommand command : commands) {
			Validate.notNull(command, "Command is null.");
			final String commandName = command.getCommandName();
			if (commandsMap.containsKey(commandName)) {
				throw new IllegalArgumentException("Duplicate command registered under '" + commandName + "' command.");
			}
			LOG.debug("Cli command '{}' registered.", commandName);
			commandsMap.put(commandName, command);
		}
	}

}
