package org.lwapp.commons.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

public final class Terminal {

	private final BufferedReader in;
	private final PrintStream out;

	public Terminal(final PrintStream ps, final InputStream inputStream) {
		in = new BufferedReader(new InputStreamReader(inputStream));
		out = ps;
	}

	public String readPassword(final String prompt) {
		print(prompt);
		final EraserThread consoleEraser = new EraserThread(out);
		try {
			consoleEraser.start();
			return in.readLine();
		} catch (final IOException e) {
			throw new RuntimeException(e);
		} finally {
			consoleEraser.halt();
		}
	}

	public String readString(final String prompt) {
		print(prompt);
		try {
			return in.readLine();
		} catch (final IOException e) {
			throw new RuntimeException(e);
		}
	}

	public void println(final String prompt) {
		out.println(prompt);
	}

	public void print(final String prompt) {
		out.print(prompt + "\t");
	}

	private static class EraserThread extends Thread {
		private boolean running = true;
		private final PrintStream out;

		public EraserThread(final PrintStream out) {
			this.out = out;
		}

		@Override
		public void run() {
			while (running) {
				out.print("\b ");
				try {
					Thread.sleep(1);
				} catch (final InterruptedException e) {
					throw new RuntimeException(e);
				}
			}
		}

		public synchronized void halt() {
			running = false;
		}
	}
}
