package org.lwapp.commons.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;

public class ClassPathResourceLoader {
    private final List<ClassLoader> classLoaders = new ArrayList<ClassLoader>();

    public ClassPathResourceLoader() {
        classLoaders.add(Thread.currentThread().getContextClassLoader());
        classLoaders.add(getClass().getClassLoader());
        classLoaders.add(ClassLoader.getSystemClassLoader());
    }

    public InputStream getResourceAsStream(final String path) {
        try {
            return getResourceUrl(path).openStream();
        } catch (final IOException e) {
            throw new RuntimeException(e);
        }
    }

    public URL getResourceUrl(final String path) {
        for (final ClassLoader classLoader : classLoaders) {
            final URL url = classLoader.getResource(StringUtils.removeStart(path, "/"));
            if (url != null) {
                return url;
            }
        }
        throw new RuntimeException(path);
    }

}
