package org.lwapp.commons.utils;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import org.reflections.Reflections;

public class ClassUtils {

	public static <T> Set<Class<? extends T>> findSubClasses(final Class<T> superClass, final String... packages) {
		final Reflections reflections = new Reflections((Object[])packages);
		return Collections.unmodifiableSet(reflections.getSubTypesOf(superClass));
	}

	public static <T> Set<Class<? extends T>> findSubClasses(final Class<T> superClass) {
		final Reflections reflections = new Reflections();
		return Collections.unmodifiableSet(reflections.getSubTypesOf(superClass));
	}

	public static Set<Class<?>> getAllClasses(final String... packages) {
		return findSubClasses(Object.class, packages);
	}
	
	public static Set<Class<?>> getAllClassesWithAnnotation(final Class<? extends Annotation> annotationClass, final String... packages) {
		final Set<Class<?>> clazzes = new HashSet<>();
		for (Class<?> clazz : findSubClasses(Object.class, packages)) {
			if(clazz.isAnnotationPresent(annotationClass)){
				clazzes.add(clazz);
			}
		}
		return Collections.unmodifiableSet(clazzes);
	}

}
