package org.lwapp.commons.utils;

import java.util.Base64;

import org.apache.shiro.crypto.AesCipherService;

public class EncryptionUtilityService {

	private final static AesCipherService aesCipherService = new AesCipherService();

	public static String getDefaultRandomKey() {
		return getRandomKey(null);
	}

	public static String getRandomKey(final String algorithm) {
		return Base64.getEncoder().encodeToString(aesCipherService.generateNewKey().getEncoded());
	}

	public static String encrypt(final byte[] data, final byte[] key) {
		return aesCipherService.encrypt(data, key).toBase64();
	}

	public static String decrypt(final byte[] data, final byte[] key) {
		return aesCipherService.decrypt(data, key).toBase64();
	}

}
