package org.lwapp.commons.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.apache.commons.io.IOUtils;
import org.lwapp.commons.file.ManifestFile;

public final class ManifestUtils {

	public static final String MANIFEST_EXT = ".MF";

	public static void createManifest(final ManifestFile manifest, final File file) throws IOException {
		final File manifestFile = new File(file.getParent(), file.getName() + MANIFEST_EXT);
		manifest.setManifestFileName(manifestFile);
		final OutputStream os = new FileOutputStream(manifestFile);
		try {
			manifest.properties.store(os, "Created by MessageServiceBus.");
		} finally {
			IOUtils.closeQuietly(os);
		}
	}

	public static ManifestFile readManifest(final File file) throws IOException {
		if (!file.exists()) {
			throw new RuntimeException("File not exists.");
		}
		String mf = file.getName();
		if (!mf.endsWith(MANIFEST_EXT)) {
			mf += MANIFEST_EXT;
		}
		final File manifestFile = new File(file.getParent(), mf);
		final InputStream in = new FileInputStream(manifestFile);
		try {
			final ManifestFile manifest = new ManifestFile();
			manifest.load(in);
			return manifest;
		} finally {
			IOUtils.closeQuietly(in);
		}
	}
}
