/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.commons.cli;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.Socket;
import org.lwapp.commons.cli.CliClientHandler;
import org.lwapp.commons.io.IoTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CliSocketHandler
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(CliSocketHandler.class);
    private final CliClientHandler cliClienttHandler;
    private final Socket socket;

    public CliSocketHandler(CliClientHandler cliClientHandler, Socket socket) {
        this.cliClienttHandler = cliClientHandler;
        this.socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            InputStream in = this.socket.getInputStream();
            try {
                PrintStream out = new PrintStream(this.socket.getOutputStream());
                try {
                    this.cliClienttHandler.handle(in, out);
                }
                finally {
                    IoTools.closeQuietly(out);
                }
            }
            finally {
                IoTools.closeQuietly(in);
            }
        }
        catch (Exception e) {
            LOG.warn("Exception while processing the client.", (Throwable)e);
        }
        finally {
            this.closeQuietly();
        }
    }

    private void closeQuietly() {
        if (!this.socket.isClosed()) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                LOG.warn("Failed to close socket. Try TERM KILL", (Throwable)e);
            }
        }
    }
}

