/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.commons.utils;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.reflections.Reflections;

public class ClassUtils {
    public static <T> Set<Class<? extends T>> findSubClasses(Class<T> superClass, String ... packages) {
        Reflections reflections = new Reflections((Object[])packages);
        return Collections.unmodifiableSet(reflections.getSubTypesOf(superClass));
    }

    public static <T> Set<Class<? extends T>> findSubClasses(Class<T> superClass) {
        Reflections reflections = new Reflections(new Object[0]);
        return Collections.unmodifiableSet(reflections.getSubTypesOf(superClass));
    }

    public static Set<Class<?>> getAllClasses(String ... packages) {
        return ClassUtils.findSubClasses(Object.class, packages);
    }

    public static Set<Class<?>> getAllClassesWithAnnotation(Class<? extends Annotation> annotationClass, String ... packages) {
        HashSet<Class<Object>> clazzes = new HashSet<Class<Object>>();
        for (Class<Object> clazz : ClassUtils.findSubClasses(Object.class, packages)) {
            if (!clazz.isAnnotationPresent(annotationClass)) continue;
            clazzes.add(clazz);
        }
        return Collections.unmodifiableSet(clazzes);
    }
}

