package org.lwapp.commons.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;

import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.SecretKeySpec;

import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public final class CompressionUtils {

	public static final String GZ_EXT = ".gz";

	public static File compressToGZIP(final File dataFile, final byte[] bytes, byte[] secret) throws Exception {
		if ((bytes == null) || (bytes.length == 0)) {
			throw new NullPointerException("Nothing to write.");
		}
		OutputStream cos = null;
		final File gzipFile = new File(dataFile.getParent(), dataFile.getName() + GZ_EXT);
		try {
			final OutputStream os;
			if ((secret != null) && (secret.length > 0)) {
				if (secret.length != 32) {
					secret = StringUtils.substring(StringUtils.leftPad(new String(secret), 32, "0"), 0, 32).getBytes();
				}
				final Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
				final SecretKeySpec secretKey = new SecretKeySpec(secret, "AES");
				cipher.init(Cipher.ENCRYPT_MODE, secretKey);
				os = new CipherOutputStream(new FileOutputStream(gzipFile), cipher);
			} else {
				os = new FileOutputStream(gzipFile);
			}
			cos = new CompressorStreamFactory().createCompressorOutputStream(CompressorStreamFactory.GZIP, os);
			IOUtils.write(bytes, cos);
		} finally {
			if (cos != null) {
				cos.flush();
			}
			IOUtils.closeQuietly(cos);
		}
		return gzipFile;
	}

	public static byte[] deCompressGZIP(final File gzipFile, byte[] secret) throws Exception {
		if (!gzipFile.exists()) {
			throw new RuntimeException("GzipFile File not exists.: " + gzipFile.getName());
		}
		final InputStream in;
		if ((secret != null) && (secret.length > 0)) {
			if (secret.length != 32) {
				secret = StringUtils.substring(StringUtils.leftPad(new String(secret), 32, "0"), 0, 32).getBytes();
			}
			final Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
			final SecretKeySpec secretKey = new SecretKeySpec(secret, "AES");
			cipher.init(Cipher.DECRYPT_MODE, secretKey);
			in = new CipherInputStream(new FileInputStream(gzipFile), cipher);
		} else {
			in = new FileInputStream(gzipFile);
		}
		return IOUtils.toByteArray(new GZIPInputStream(in));
	}

	public static long checksumCRC32(final File file) throws Exception {
		return FileUtils.checksumCRC32(file);
	}

}
