package org.lwapp.commons.utils;


import static java.util.regex.Pattern.CASE_INSENSITIVE;

import java.net.IDN;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EmailValidator  {
	private static String ATOM = "[a-z0-9!#$%&'*+/=?^_`{|}~-]";
	private static String DOMAIN = ATOM + "+(\\." + ATOM + "+)*";
	private static String IP_DOMAIN = "\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\]";

	private static final Pattern localPattern = java.util.regex.Pattern.compile(
			ATOM + "+(\\." + ATOM + "+)*", CASE_INSENSITIVE
	);

	private static final Pattern domainPattern = java.util.regex.Pattern.compile(
			DOMAIN + "|" + IP_DOMAIN, CASE_INSENSITIVE
	);


	public static boolean isValid(CharSequence value) {
		if ( value == null || value.length() == 0 ) {
			return true;
		}

		String[] emailParts = value.toString().split( "@", 3 );
		if ( emailParts.length != 2 ) {
			return false;
		}

		if ( emailParts[0].endsWith( "." ) || emailParts[1].endsWith( "." ) ) {
			return false;
		}

		if ( !matchPart( emailParts[0], localPattern ) ) {
			return false;
		}

		return matchPart( emailParts[1], domainPattern );
	}

	private static boolean matchPart(String part, Pattern pattern) {
		try {
			part = IDN.toASCII( part );
		}
		catch ( IllegalArgumentException e ) {
			return false;
		}
		Matcher matcher = pattern.matcher( part );
		return matcher.matches();
	}
}
