/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.commons.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ClassPathResourceLoader {
    private final List<ClassLoader> classLoaders = new ArrayList<ClassLoader>();

    public ClassPathResourceLoader() {
        this.classLoaders.add(Thread.currentThread().getContextClassLoader());
        this.classLoaders.add(this.getClass().getClassLoader());
        this.classLoaders.add(ClassLoader.getSystemClassLoader());
    }

    public InputStream getResourceAsStream(String path) {
        try {
            return this.getResourceUrl(path).openStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public URL getResourceUrl(String path) {
        for (ClassLoader classLoader : this.classLoaders) {
            URL url = classLoader.getResource(StringUtils.removeStart((String)path, (String)"/"));
            if (url == null) continue;
            return url;
        }
        throw new RuntimeException(path);
    }
}

