package org.lwapp.commons;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import org.slf4j.MDC;

@XmlRootElement(name = "ErrorResponse")
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ErrorResponse", propOrder = { "errorCode", "errorMessage", "logTraceId" })
public class ErrorResponse implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private String errorCode;
	private String errorMessage;
	private String logTraceId;

	private ErrorResponse() {
	}

	public ErrorResponse(final String errorMessage) {
		super();
		this.errorMessage = errorMessage;
		this.logTraceId = MDC.get("logTraceId");
	}

	public String getErrorMessage() {
		return errorMessage;
	}

	public void setErrorMessage(final String errorMessage) {
		this.errorMessage = errorMessage;
	}

	public String getLogTraceId() {
		return logTraceId;
	}

	public void setLogTraceId(final String logTraceId) {
		this.logTraceId = logTraceId;
	}

	public String getErrorCode() {
		return errorCode;
	}

	public void setErrorCode(String errorCode) {
		this.errorCode = errorCode;
	}

	public static class Builder {
		private String errorCode;
		private String errorMessage;
		private String logTraceId;

		public Builder errorCode(String errorCode) {
			this.errorCode = errorCode;
			return this;
		}

		public Builder errorMessage(String errorMessage) {
			this.errorMessage = errorMessage;
			return this;
		}

		public Builder logTraceId(String logTraceId) {
			this.logTraceId = logTraceId;
			return this;
		}

		public ErrorResponse build() {
			ErrorResponse errorResponse = new ErrorResponse();
			errorResponse.errorCode = errorCode;
			errorResponse.errorMessage = errorMessage;
			errorResponse.logTraceId = logTraceId;
			return errorResponse;
		}
	}
}
