package org.lwapp.commons.cli;

import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelnetClientHandler implements CliClientHandler {
	private static final Logger LOG = LoggerFactory.getLogger(TelnetClientHandler.class);

	private final String commandPrompt;

	private final Cli cli;

	public TelnetClientHandler(final String prompt, final Cli cli) {
		this.commandPrompt = prompt;
		this.cli = cli;
	}

	@Override
	public void handle(final InputStream in, final PrintStream out) throws Exception {
		final PrintWriter pw = new PrintWriter(out);
		out.println("Waiting for commands. Type '?' to get list of all available commands.");
		out.print(commandPrompt);
		StringBuilder sb = new StringBuilder();
		for (;;) {
			final int data = in.read();
			if ((data == -1) || (Ascii.CTRL_D.eq(data))) {
				out.println("");
				break;
			}
			if (Ascii.LF.eq(data)) {
				final String line = sb.toString().trim();
				sb = new StringBuilder();
				LOG.info("Command line: '{}'", line);
				if ("exit".equals(line)) {
					break;
				}
				if (StringUtils.isNotBlank(line)) {

					cli.process(new Terminal(out, in), line);
					pw.println();
					pw.flush();
				}
				out.println();
				out.print(commandPrompt + "$");
			}
			if (Ascii.isPrintable(data)) {
				sb.append((char) data);
			}
			if ((Ascii.BS.eq(data))) {
				final boolean isWinXP = System.getProperty("os.name", "").equals("Windows XP");
				if (isWinXP) {
					out.write(' ');
				}
				if (sb.length() > 0) {
					sb.setLength(sb.length() - 1);
					out.write(Ascii.BS.intValue());
				}
			} else if (Ascii.ESC.eq(data)) {
				out.print("^["); // '^'
			}
		}
		out.println("Bye.");
	}
}
