/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.commons.cli;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.lwapp.commons.cli.AbstractCommand;
import org.lwapp.commons.cli.Command;
import org.lwapp.commons.cli.Terminal;

public class Cli {
    private final Map<String, AbstractCommand> commandsMap;

    public Cli(Map<String, AbstractCommand> aCommands) {
        this.commandsMap = new HashMap<String, AbstractCommand>(aCommands);
    }

    public void process(Terminal term, String commandNameLine) {
        String trimmedCommandLine = StringUtils.defaultString((String)commandNameLine).trim();
        if (StringUtils.isNotBlank((String)trimmedCommandLine)) {
            String commandName = StringUtils.substringBefore((String)trimmedCommandLine, (String)" ");
            if ("?".equals(commandName)) {
                this.printAllComands(term);
                return;
            }
            Command command = this.commandsMap.get(commandName);
            if (command == null) {
                term.println("Bad command '" + commandName + "'.\n");
                this.printAllComands(term);
            } else {
                try {
                    command.execute(term, StringUtils.substringAfter((String)trimmedCommandLine, (String)" "));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void printAllComands(Terminal term) {
        for (Map.Entry<String, AbstractCommand> entry : this.commandsMap.entrySet()) {
            entry.getValue().printUsage(term);
        }
    }
}

