package org.lwapp.commons.cli;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.Socket;

import org.lwapp.commons.io.IoTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

// Used in the package
final class CliSocketHandler implements Runnable {
	private static final Logger LOG = LoggerFactory.getLogger(CliSocketHandler.class);

	private final CliClientHandler cliClienttHandler;
	private final Socket socket;

	public CliSocketHandler(final CliClientHandler cliClientHandler, final Socket socket) {
		this.cliClienttHandler = cliClientHandler;
		this.socket = socket;
	}

	@Override
	public void run() {
		try {
			final InputStream in = socket.getInputStream();
			try {
				final PrintStream out = new PrintStream(socket.getOutputStream());
				try {
					cliClienttHandler.handle(in, out);
				} finally {
					IoTools.closeQuietly(out);
				}
			} finally {
				IoTools.closeQuietly(in);
			}
		} catch (final Exception e) {
			LOG.warn("Exception while processing the client.", e);
		} finally {
			closeQuietly();
		}
	}

	private void closeQuietly() {
		if (!socket.isClosed()) {
			try {
				socket.close();
			} catch (final IOException e) {
				LOG.warn("Failed to close socket. Try TERM KILL", e);
			}
		}
	}

}
