package org.lwapp.commons.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

import org.apache.commons.io.IOUtils;

public final class IOStreamUtils {

	public static byte[] toByteArray(final InputStream in) throws IOException {
		ByteArrayOutputStream out = null;
		try {
			out = new ByteArrayOutputStream();
			IOUtils.copyLarge(in, out);
			out.flush();
			return out.toByteArray();
		} finally {
			IOUtils.closeQuietly(out);
		}
	}
}
