package org.lwapp.commons.utils;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Set;

import org.reflections.Reflections;

public class ClassUtils {

	public static <T> Set<Class<? extends T>> findSubClasses(final Class<T> superClass, final String... packages) {
		final Reflections reflections = new Reflections((Object[])packages);
		return Collections.unmodifiableSet(reflections.getSubTypesOf(superClass));
	}

	public static <T> Set<Class<? extends T>> findSubClasses(final Class<T> superClass) {
		final Reflections reflections = new Reflections();
		return Collections.unmodifiableSet(reflections.getSubTypesOf(superClass));
	}

	public static Set<Class<?>> getAllClassesWithAnnotation(final Class<? extends Annotation> annotation, final String... packages) {
		final Reflections reflections = new Reflections((Object[])packages);
		return  Collections.unmodifiableSet(reflections.getTypesAnnotatedWith(annotation,true));
	}

}
