/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.commons.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

public final class Terminal {
    private final BufferedReader in;
    private final PrintStream out;

    public Terminal(PrintStream ps, InputStream inputStream) {
        this.in = new BufferedReader(new InputStreamReader(inputStream));
        this.out = ps;
    }

    public String readPassword(String prompt) {
        this.print(prompt);
        EraserThread consoleEraser = new EraserThread(this.out);
        try {
            consoleEraser.start();
            String string = this.in.readLine();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            consoleEraser.halt();
        }
    }

    public String readString(String prompt) {
        this.print(prompt);
        try {
            return this.in.readLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void println(String prompt) {
        this.out.println(prompt);
    }

    public void print(String prompt) {
        this.out.print(prompt + "\t");
    }

    private static class EraserThread
    extends Thread {
        private boolean running = true;
        private final PrintStream out;

        public EraserThread(PrintStream out) {
            this.out = out;
        }

        @Override
        public void run() {
            while (this.running) {
                this.out.print("\b ");
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public synchronized void halt() {
            this.running = false;
        }
    }
}

