/*
 * Decompiled with CFR 0.152.
 */
package org.lwapp.commons.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import org.lwapp.commons.io.ClassPathResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IoTools {
    private static final Logger LOG = LoggerFactory.getLogger(IoTools.class);
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    protected IoTools() {
        throw new UnsupportedOperationException();
    }

    public static void closeQuietly(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException e) {
            LOG.warn("Exception occured while closing inputstream.", (Throwable)e);
        }
    }

    public static void closeQuietly(OutputStream outputStream) {
        try {
            outputStream.close();
        }
        catch (IOException e) {
            LOG.warn("Failed to closing the outputStream.", (Throwable)e);
        }
    }

    public static void closeQuietly(Reader reader) {
        try {
            reader.close();
        }
        catch (IOException e) {
            LOG.warn("Failed to closing the reader.", (Throwable)e);
        }
    }

    public static void closeQuietly(Writer writer) {
        try {
            writer.close();
        }
        catch (IOException e) {
            LOG.warn("Failed to closing the writer.", (Throwable)e);
        }
    }

    public static URL getResourceUrl(String path) {
        return new ClassPathResourceLoader().getResourceUrl(path);
    }

    public static InputStream getResourceAsStream(String path) {
        return new ClassPathResourceLoader().getResourceAsStream(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResourceAsString(String path, Charset charset) {
        InputStream inputStream = IoTools.getResourceAsStream(path);
        try {
            String string = IoTools.toString(inputStream, charset);
            return string;
        }
        finally {
            IoTools.closeQuietly(inputStream);
        }
    }

    public static String toString(InputStream inputStream, Charset charset) {
        StringWriter sw = new StringWriter(4096);
        IoTools.copy(new InputStreamReader(inputStream, charset), sw);
        return sw.toString();
    }

    private static void copy(Reader reader, Writer writer) {
        try {
            int n;
            char[] buffer = new char[4096];
            while ((n = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, n);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

