package org.lwapp.commons;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import org.slf4j.MDC;

@XmlRootElement(name = "ErrorResponse")
@XmlAccessorType(XmlAccessType.FIELD)
public class ErrorResponse implements Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    private String errorCode;
    private String errorMessage;
    private String errorDetails;
    private String logTraceId;

    private ErrorResponse() {
    }

    public ErrorResponse(final String errorMessage) {
        super();
        this.errorMessage = errorMessage;
        logTraceId = MDC.get("logTraceId");
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(final String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getLogTraceId() {
        return logTraceId;
    }

    public void setLogTraceId(final String logTraceId) {
        this.logTraceId = logTraceId;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(final String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorDetails() {
        return errorDetails;
    }

    public void setErrorDetails(final String errorDetails) {
        this.errorDetails = errorDetails;
    }

    public static class Builder {
        private String errorCode;
        private String errorMessage;
        private String errorDetails;

        public Builder errorCode(final String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public Builder errorMessage(final String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public Builder errorDetails(final String errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public ErrorResponse build() {
            final ErrorResponse errorResponse = new ErrorResponse();
            errorResponse.errorCode = errorCode;
            errorResponse.errorMessage = errorMessage;
            errorResponse.errorDetails = errorDetails;
            errorResponse.logTraceId = MDC.get("logTraceId");
            return errorResponse;
        }
    }
}
