package org.lwapp.commons;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;

@XmlAccessorType(XmlAccessType.FIELD)
public class PropertyList implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    @XmlElement(name = "name")
    private String name;
    @XmlElementWrapper(name = "values")
    @XmlElement(name = "value")
    private final List<String> values = new ArrayList<>();

    PropertyList() {
        name = null;
    }

    public PropertyList(final String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public void setName(final String name) {
        this.name = name;
    }

    public List<String> getValues() {
        return values;
    }

    public void addValues(final List<String> values) {
        this.values.addAll(values);
    }

    public void addValue(final String value) {
        values.add(value);
    }

}
