package org.lwapp.commons.cli;

import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public final class Terminal {

    private final BufferedReader in;
    private final PrintStream out;

    public Terminal(final PrintStream ps, final InputStream inputStream) {
        in = new BufferedReader(new InputStreamReader(inputStream));
        out = ps;
    }

    public Terminal() {
        in = new BufferedReader(new InputStreamReader(System.in));
        out = System.out;
    }

    public String readString(final String prompt) {
        print(prompt);
        try {
            return in.readLine();
        } catch (final IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String readString(final String prompt, final String defaultValue) {
        Validate.notBlank(defaultValue, "Default value cannot be blank.");
        print(prompt + "[" + defaultValue + "]");
        try {
            final String readLine = in.readLine();
            return StringUtils.isNotBlank(readLine) ? readLine : defaultValue;
        } catch (final IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void println(final String prompt) {
        out.println(prompt);
    }

    public void print(final String prompt) {
        out.print(prompt);
    }

    public String readPassword(final String prompt) {
        final Console console = System.console();
        if (console == null) {
            return readString(prompt);
        } else {
            return new String(console.readPassword(prompt));
        }
    }
}
